/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.ResourceSkusClient;
import com.azure.resourcemanager.compute.fluent.models.ResourceSkuInner;
import com.azure.resourcemanager.compute.implementation.ComputeSkuImpl;
import com.azure.resourcemanager.compute.models.ComputeResourceType;
import com.azure.resourcemanager.compute.models.ComputeSku;
import com.azure.resourcemanager.compute.models.ComputeSkus;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public final class ComputeSkusImpl
extends ReadableWrappersImpl<ComputeSku, ComputeSkuImpl, ResourceSkuInner>
implements ComputeSkus {
    private final ComputeManager manager;

    public ComputeSkusImpl(ComputeManager computeManager) {
        this.manager = computeManager;
    }

    protected ComputeSkuImpl wrapModel(ResourceSkuInner inner) {
        return new ComputeSkuImpl(inner);
    }

    public PagedIterable<ComputeSku> list() {
        return this.wrapList(this.inner().list());
    }

    public PagedFlux<ComputeSku> listAsync() {
        return this.wrapPageAsync(this.inner().listAsync());
    }

    public PagedIterable<ComputeSku> listByRegion(String regionName) {
        return this.listByRegion(Region.fromName((String)regionName));
    }

    public PagedIterable<ComputeSku> listByRegion(Region region) {
        return new PagedIterable(this.listByRegionAsync(region));
    }

    public PagedFlux<ComputeSku> listByRegionAsync(String regionName) {
        return this.listByRegionAsync(Region.fromName((String)regionName));
    }

    public PagedFlux<ComputeSku> listByRegionAsync(Region region) {
        return PagedConverter.mapPage(this.inner().listAsync(String.format("location eq '%s'", region.name())), this::wrapModel);
    }

    public ResourceSkusClient inner() {
        return ((ComputeManagementClient)this.manager.serviceClient()).getResourceSkus();
    }

    public ComputeManager manager() {
        return this.manager;
    }

    @Override
    public PagedIterable<ComputeSku> listByResourceType(ComputeResourceType resourceType) {
        return new PagedIterable(this.listByResourceTypeAsync(resourceType));
    }

    @Override
    public PagedFlux<ComputeSku> listByResourceTypeAsync(ComputeResourceType resourceType) {
        return PagedConverter.flatMapPage((PagedFlux)this.wrapPageAsync(this.inner().listAsync()), computeSku -> {
            if (computeSku.resourceType() != null && computeSku.resourceType().equals((Object)resourceType)) {
                return Mono.just((Object)computeSku);
            }
            return Mono.empty();
        });
    }

    @Override
    public PagedIterable<ComputeSku> listByRegionAndResourceType(Region region, ComputeResourceType resourceType) {
        return new PagedIterable(this.listByRegionAndResourceTypeAsync(region, resourceType));
    }

    @Override
    public PagedFlux<ComputeSku> listByRegionAndResourceTypeAsync(Region region, ComputeResourceType resourceType) {
        return PagedConverter.flatMapPage((PagedFlux)this.wrapPageAsync(this.inner().listAsync(String.format("location eq '%s'", region.name()))), computeSku -> {
            if (computeSku.resourceType() != null && computeSku.resourceType().equals((Object)resourceType)) {
                return Mono.just((Object)computeSku);
            }
            return Mono.empty();
        });
    }
}

