/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMInstanceViewInner;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.HardwareProfile;
import com.azure.resourcemanager.compute.models.NetworkProfile;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMNetworkProfileConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMProtectionPolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualMachineScaleSetVMInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetVMInner.class);
    @JsonProperty(value="instanceId", access=JsonProperty.Access.WRITE_ONLY)
    private String instanceId;
    @JsonProperty(value="sku", access=JsonProperty.Access.WRITE_ONLY)
    private Sku sku;
    @JsonProperty(value="plan")
    private Plan plan;
    @JsonProperty(value="resources", access=JsonProperty.Access.WRITE_ONLY)
    private List<VirtualMachineExtensionInner> resources;
    @JsonProperty(value="zones", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> zones;
    @JsonProperty(value="properties.latestModelApplied", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean latestModelApplied;
    @JsonProperty(value="properties.vmId", access=JsonProperty.Access.WRITE_ONLY)
    private String vmId;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private VirtualMachineScaleSetVMInstanceViewInner instanceView;
    @JsonProperty(value="properties.hardwareProfile")
    private HardwareProfile hardwareProfile;
    @JsonProperty(value="properties.storageProfile")
    private StorageProfile storageProfile;
    @JsonProperty(value="properties.additionalCapabilities")
    private AdditionalCapabilities additionalCapabilities;
    @JsonProperty(value="properties.osProfile")
    private OSProfile osProfile;
    @JsonProperty(value="properties.securityProfile")
    private SecurityProfile securityProfile;
    @JsonProperty(value="properties.networkProfile")
    private NetworkProfile networkProfile;
    @JsonProperty(value="properties.networkProfileConfiguration")
    private VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration;
    @JsonProperty(value="properties.diagnosticsProfile")
    private DiagnosticsProfile diagnosticsProfile;
    @JsonProperty(value="properties.availabilitySet")
    private SubResource availabilitySet;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.licenseType")
    private String licenseType;
    @JsonProperty(value="properties.modelDefinitionApplied", access=JsonProperty.Access.WRITE_ONLY)
    private String modelDefinitionApplied;
    @JsonProperty(value="properties.protectionPolicy")
    private VirtualMachineScaleSetVMProtectionPolicy protectionPolicy;
    @JsonProperty(value="properties.userData")
    private String userData;

    public String instanceId() {
        return this.instanceId;
    }

    public Sku sku() {
        return this.sku;
    }

    public Plan plan() {
        return this.plan;
    }

    public VirtualMachineScaleSetVMInner withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public List<VirtualMachineExtensionInner> resources() {
        return this.resources;
    }

    public List<String> zones() {
        return this.zones;
    }

    public Boolean latestModelApplied() {
        return this.latestModelApplied;
    }

    public String vmId() {
        return this.vmId;
    }

    public VirtualMachineScaleSetVMInstanceViewInner instanceView() {
        return this.instanceView;
    }

    public HardwareProfile hardwareProfile() {
        return this.hardwareProfile;
    }

    public VirtualMachineScaleSetVMInner withHardwareProfile(HardwareProfile hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public VirtualMachineScaleSetVMInner withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.additionalCapabilities;
    }

    public VirtualMachineScaleSetVMInner withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        this.additionalCapabilities = additionalCapabilities;
        return this;
    }

    public OSProfile osProfile() {
        return this.osProfile;
    }

    public VirtualMachineScaleSetVMInner withOsProfile(OSProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public VirtualMachineScaleSetVMInner withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public VirtualMachineScaleSetVMInner withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration() {
        return this.networkProfileConfiguration;
    }

    public VirtualMachineScaleSetVMInner withNetworkProfileConfiguration(VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration) {
        this.networkProfileConfiguration = networkProfileConfiguration;
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.diagnosticsProfile;
    }

    public VirtualMachineScaleSetVMInner withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        this.diagnosticsProfile = diagnosticsProfile;
        return this;
    }

    public SubResource availabilitySet() {
        return this.availabilitySet;
    }

    public VirtualMachineScaleSetVMInner withAvailabilitySet(SubResource availabilitySet) {
        this.availabilitySet = availabilitySet;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public VirtualMachineScaleSetVMInner withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String modelDefinitionApplied() {
        return this.modelDefinitionApplied;
    }

    public VirtualMachineScaleSetVMProtectionPolicy protectionPolicy() {
        return this.protectionPolicy;
    }

    public VirtualMachineScaleSetVMInner withProtectionPolicy(VirtualMachineScaleSetVMProtectionPolicy protectionPolicy) {
        this.protectionPolicy = protectionPolicy;
        return this;
    }

    public String userData() {
        return this.userData;
    }

    public VirtualMachineScaleSetVMInner withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public VirtualMachineScaleSetVMInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualMachineScaleSetVMInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.hardwareProfile() != null) {
            this.hardwareProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.additionalCapabilities() != null) {
            this.additionalCapabilities().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.networkProfileConfiguration() != null) {
            this.networkProfileConfiguration().validate();
        }
        if (this.diagnosticsProfile() != null) {
            this.diagnosticsProfile().validate();
        }
        if (this.protectionPolicy() != null) {
            this.protectionPolicy().validate();
        }
    }
}

