/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.RunCommandInputParameter;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandInstanceView;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandScriptSource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualMachineRunCommandInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineRunCommandInner.class);
    @JsonProperty(value="properties.source")
    private VirtualMachineRunCommandScriptSource source;
    @JsonProperty(value="properties.parameters")
    private List<RunCommandInputParameter> parameters;
    @JsonProperty(value="properties.protectedParameters")
    private List<RunCommandInputParameter> protectedParameters;
    @JsonProperty(value="properties.asyncExecution")
    private Boolean asyncExecution;
    @JsonProperty(value="properties.runAsUser")
    private String runAsUser;
    @JsonProperty(value="properties.runAsPassword")
    private String runAsPassword;
    @JsonProperty(value="properties.timeoutInSeconds")
    private Integer timeoutInSeconds;
    @JsonProperty(value="properties.outputBlobUri")
    private String outputBlobUri;
    @JsonProperty(value="properties.errorBlobUri")
    private String errorBlobUri;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private VirtualMachineRunCommandInstanceView instanceView;

    public VirtualMachineRunCommandScriptSource source() {
        return this.source;
    }

    public VirtualMachineRunCommandInner withSource(VirtualMachineRunCommandScriptSource source) {
        this.source = source;
        return this;
    }

    public List<RunCommandInputParameter> parameters() {
        return this.parameters;
    }

    public VirtualMachineRunCommandInner withParameters(List<RunCommandInputParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<RunCommandInputParameter> protectedParameters() {
        return this.protectedParameters;
    }

    public VirtualMachineRunCommandInner withProtectedParameters(List<RunCommandInputParameter> protectedParameters) {
        this.protectedParameters = protectedParameters;
        return this;
    }

    public Boolean asyncExecution() {
        return this.asyncExecution;
    }

    public VirtualMachineRunCommandInner withAsyncExecution(Boolean asyncExecution) {
        this.asyncExecution = asyncExecution;
        return this;
    }

    public String runAsUser() {
        return this.runAsUser;
    }

    public VirtualMachineRunCommandInner withRunAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    public String runAsPassword() {
        return this.runAsPassword;
    }

    public VirtualMachineRunCommandInner withRunAsPassword(String runAsPassword) {
        this.runAsPassword = runAsPassword;
        return this;
    }

    public Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public VirtualMachineRunCommandInner withTimeoutInSeconds(Integer timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
        return this;
    }

    public String outputBlobUri() {
        return this.outputBlobUri;
    }

    public VirtualMachineRunCommandInner withOutputBlobUri(String outputBlobUri) {
        this.outputBlobUri = outputBlobUri;
        return this;
    }

    public String errorBlobUri() {
        return this.errorBlobUri;
    }

    public VirtualMachineRunCommandInner withErrorBlobUri(String errorBlobUri) {
        this.errorBlobUri = errorBlobUri;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public VirtualMachineRunCommandInstanceView instanceView() {
        return this.instanceView;
    }

    public VirtualMachineRunCommandInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualMachineRunCommandInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
        if (this.protectedParameters() != null) {
            this.protectedParameters().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

