/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.CapacityReservationInstanceView;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class CapacityReservationInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CapacityReservationInner.class);
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="properties.reservationId", access=JsonProperty.Access.WRITE_ONLY)
    private String reservationId;
    @JsonProperty(value="properties.virtualMachinesAssociated", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceReadOnly> virtualMachinesAssociated;
    @JsonProperty(value="properties.provisioningTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime provisioningTime;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private CapacityReservationInstanceView instanceView;

    public Sku sku() {
        return this.sku;
    }

    public CapacityReservationInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public CapacityReservationInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String reservationId() {
        return this.reservationId;
    }

    public List<SubResourceReadOnly> virtualMachinesAssociated() {
        return this.virtualMachinesAssociated;
    }

    public OffsetDateTime provisioningTime() {
        return this.provisioningTime;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public CapacityReservationInstanceView instanceView() {
        return this.instanceView;
    }

    public CapacityReservationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CapacityReservationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model CapacityReservationInner"));
        }
        this.sku().validate();
        if (this.virtualMachinesAssociated() != null) {
            this.virtualMachinesAssociated().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

