/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.DiskInner;
import java.io.IOException;
import java.util.List;

public final class DiskList
implements JsonSerializable<DiskList> {
    private List<DiskInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DiskList.class);

    public List<DiskInner> value() {
        return this.value;
    }

    public DiskList withValue(List<DiskInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public DiskList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DiskList"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static DiskList fromJson(JsonReader jsonReader) throws IOException {
        return (DiskList)jsonReader.readObject(reader -> {
            DiskList deserializedDiskList = new DiskList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDiskList.value = value = reader.readArray(reader1 -> DiskInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDiskList.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskList;
        });
    }
}

