/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DiskDetachOptionTypes;
import java.io.IOException;

public final class DataDisksToDetach
implements JsonSerializable<DataDisksToDetach> {
    private String diskId;
    private DiskDetachOptionTypes detachOption;
    private static final ClientLogger LOGGER = new ClientLogger(DataDisksToDetach.class);

    public String diskId() {
        return this.diskId;
    }

    public DataDisksToDetach withDiskId(String diskId) {
        this.diskId = diskId;
        return this;
    }

    public DiskDetachOptionTypes detachOption() {
        return this.detachOption;
    }

    public DataDisksToDetach withDetachOption(DiskDetachOptionTypes detachOption) {
        this.detachOption = detachOption;
        return this;
    }

    public void validate() {
        if (this.diskId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property diskId in model DataDisksToDetach"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("diskId", this.diskId);
        jsonWriter.writeStringField("detachOption", this.detachOption == null ? null : this.detachOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataDisksToDetach fromJson(JsonReader jsonReader) throws IOException {
        return (DataDisksToDetach)jsonReader.readObject(reader -> {
            DataDisksToDetach deserializedDataDisksToDetach = new DataDisksToDetach();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("diskId".equals(fieldName)) {
                    deserializedDataDisksToDetach.diskId = reader.getString();
                    continue;
                }
                if ("detachOption".equals(fieldName)) {
                    deserializedDataDisksToDetach.detachOption = DiskDetachOptionTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataDisksToDetach;
        });
    }
}

