/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiskCreateOptionTypes;
import com.azure.resourcemanager.compute.models.DiskDeleteOptionTypes;
import com.azure.resourcemanager.compute.models.DiskDetachOptionTypes;
import com.azure.resourcemanager.compute.models.ManagedDiskParameters;
import com.azure.resourcemanager.compute.models.VirtualHardDisk;
import java.io.IOException;

public final class DataDisk
implements JsonSerializable<DataDisk> {
    private int lun;
    private String name;
    private VirtualHardDisk vhd;
    private VirtualHardDisk image;
    private CachingTypes caching;
    private Boolean writeAcceleratorEnabled;
    private DiskCreateOptionTypes createOption;
    private Integer diskSizeGB;
    private ManagedDiskParameters managedDisk;
    private ApiEntityReference sourceResource;
    private Boolean toBeDetached;
    private Long diskIopsReadWrite;
    private Long diskMBpsReadWrite;
    private DiskDetachOptionTypes detachOption;
    private DiskDeleteOptionTypes deleteOption;
    private static final ClientLogger LOGGER = new ClientLogger(DataDisk.class);

    public int lun() {
        return this.lun;
    }

    public DataDisk withLun(int lun) {
        this.lun = lun;
        return this;
    }

    public String name() {
        return this.name;
    }

    public DataDisk withName(String name) {
        this.name = name;
        return this;
    }

    public VirtualHardDisk vhd() {
        return this.vhd;
    }

    public DataDisk withVhd(VirtualHardDisk vhd) {
        this.vhd = vhd;
        return this;
    }

    public VirtualHardDisk image() {
        return this.image;
    }

    public DataDisk withImage(VirtualHardDisk image) {
        this.image = image;
        return this;
    }

    public CachingTypes caching() {
        return this.caching;
    }

    public DataDisk withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public DataDisk withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public DiskCreateOptionTypes createOption() {
        return this.createOption;
    }

    public DataDisk withCreateOption(DiskCreateOptionTypes createOption) {
        this.createOption = createOption;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public DataDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public ManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    public DataDisk withManagedDisk(ManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public ApiEntityReference sourceResource() {
        return this.sourceResource;
    }

    public DataDisk withSourceResource(ApiEntityReference sourceResource) {
        this.sourceResource = sourceResource;
        return this;
    }

    public Boolean toBeDetached() {
        return this.toBeDetached;
    }

    public DataDisk withToBeDetached(Boolean toBeDetached) {
        this.toBeDetached = toBeDetached;
        return this;
    }

    public Long diskIopsReadWrite() {
        return this.diskIopsReadWrite;
    }

    public Long diskMBpsReadWrite() {
        return this.diskMBpsReadWrite;
    }

    public DiskDetachOptionTypes detachOption() {
        return this.detachOption;
    }

    public DataDisk withDetachOption(DiskDetachOptionTypes detachOption) {
        this.detachOption = detachOption;
        return this;
    }

    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    public DataDisk withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public void validate() {
        if (this.vhd() != null) {
            this.vhd().validate();
        }
        if (this.image() != null) {
            this.image().validate();
        }
        if (this.createOption() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property createOption in model DataDisk"));
        }
        if (this.managedDisk() != null) {
            this.managedDisk().validate();
        }
        if (this.sourceResource() != null) {
            this.sourceResource().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("lun", this.lun);
        jsonWriter.writeStringField("createOption", this.createOption == null ? null : this.createOption.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("vhd", (JsonSerializable)this.vhd);
        jsonWriter.writeJsonField("image", (JsonSerializable)this.image);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB);
        jsonWriter.writeJsonField("managedDisk", (JsonSerializable)this.managedDisk);
        jsonWriter.writeJsonField("sourceResource", (JsonSerializable)this.sourceResource);
        jsonWriter.writeBooleanField("toBeDetached", this.toBeDetached);
        jsonWriter.writeStringField("detachOption", this.detachOption == null ? null : this.detachOption.toString());
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataDisk fromJson(JsonReader jsonReader) throws IOException {
        return (DataDisk)jsonReader.readObject(reader -> {
            DataDisk deserializedDataDisk = new DataDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lun".equals(fieldName)) {
                    deserializedDataDisk.lun = reader.getInt();
                    continue;
                }
                if ("createOption".equals(fieldName)) {
                    deserializedDataDisk.createOption = DiskCreateOptionTypes.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDataDisk.name = reader.getString();
                    continue;
                }
                if ("vhd".equals(fieldName)) {
                    deserializedDataDisk.vhd = VirtualHardDisk.fromJson(reader);
                    continue;
                }
                if ("image".equals(fieldName)) {
                    deserializedDataDisk.image = VirtualHardDisk.fromJson(reader);
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedDataDisk.caching = CachingTypes.fromString(reader.getString());
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedDataDisk.writeAcceleratorEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedDataDisk.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedDataDisk.managedDisk = ManagedDiskParameters.fromJson(reader);
                    continue;
                }
                if ("sourceResource".equals(fieldName)) {
                    deserializedDataDisk.sourceResource = ApiEntityReference.fromJson(reader);
                    continue;
                }
                if ("toBeDetached".equals(fieldName)) {
                    deserializedDataDisk.toBeDetached = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("diskIOPSReadWrite".equals(fieldName)) {
                    deserializedDataDisk.diskIopsReadWrite = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("diskMBpsReadWrite".equals(fieldName)) {
                    deserializedDataDisk.diskMBpsReadWrite = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("detachOption".equals(fieldName)) {
                    deserializedDataDisk.detachOption = DiskDetachOptionTypes.fromString(reader.getString());
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedDataDisk.deleteOption = DiskDeleteOptionTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataDisk;
        });
    }
}

