/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryArtifactVersionFullSource;
import com.azure.resourcemanager.compute.models.GalleryDataDiskImage;
import com.azure.resourcemanager.compute.models.GalleryOSDiskImage;
import java.io.IOException;
import java.util.List;

public final class GalleryImageVersionStorageProfile
implements JsonSerializable<GalleryImageVersionStorageProfile> {
    private GalleryArtifactVersionFullSource source;
    private GalleryOSDiskImage osDiskImage;
    private List<GalleryDataDiskImage> dataDiskImages;

    public GalleryArtifactVersionFullSource source() {
        return this.source;
    }

    public GalleryImageVersionStorageProfile withSource(GalleryArtifactVersionFullSource source) {
        this.source = source;
        return this;
    }

    public GalleryOSDiskImage osDiskImage() {
        return this.osDiskImage;
    }

    public GalleryImageVersionStorageProfile withOsDiskImage(GalleryOSDiskImage osDiskImage) {
        this.osDiskImage = osDiskImage;
        return this;
    }

    public List<GalleryDataDiskImage> dataDiskImages() {
        return this.dataDiskImages;
    }

    public GalleryImageVersionStorageProfile withDataDiskImages(List<GalleryDataDiskImage> dataDiskImages) {
        this.dataDiskImages = dataDiskImages;
        return this;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.osDiskImage() != null) {
            this.osDiskImage().validate();
        }
        if (this.dataDiskImages() != null) {
            this.dataDiskImages().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        jsonWriter.writeJsonField("osDiskImage", (JsonSerializable)this.osDiskImage);
        jsonWriter.writeArrayField("dataDiskImages", this.dataDiskImages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static GalleryImageVersionStorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryImageVersionStorageProfile)jsonReader.readObject(reader -> {
            GalleryImageVersionStorageProfile deserializedGalleryImageVersionStorageProfile = new GalleryImageVersionStorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedGalleryImageVersionStorageProfile.source = GalleryArtifactVersionFullSource.fromJson(reader);
                    continue;
                }
                if ("osDiskImage".equals(fieldName)) {
                    deserializedGalleryImageVersionStorageProfile.osDiskImage = GalleryOSDiskImage.fromJson(reader);
                    continue;
                }
                if ("dataDiskImages".equals(fieldName)) {
                    List dataDiskImages;
                    deserializedGalleryImageVersionStorageProfile.dataDiskImages = dataDiskImages = reader.readArray(reader1 -> GalleryDataDiskImage.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryImageVersionStorageProfile;
        });
    }
}

