/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DiskCreateOption;
import com.azure.resourcemanager.compute.models.ImageDiskReference;
import com.azure.resourcemanager.compute.models.ProvisionedBandwidthCopyOption;
import java.io.IOException;

public final class CreationData
implements JsonSerializable<CreationData> {
    private DiskCreateOption createOption;
    private String storageAccountId;
    private ImageDiskReference imageReference;
    private ImageDiskReference galleryImageReference;
    private String sourceUri;
    private String sourceResourceId;
    private String sourceUniqueId;
    private Long uploadSizeBytes;
    private Integer logicalSectorSize;
    private String securityDataUri;
    private String securityMetadataUri;
    private Boolean performancePlus;
    private String elasticSanResourceId;
    private ProvisionedBandwidthCopyOption provisionedBandwidthCopySpeed;
    private Long instantAccessDurationMinutes;
    private static final ClientLogger LOGGER = new ClientLogger(CreationData.class);

    public DiskCreateOption createOption() {
        return this.createOption;
    }

    public CreationData withCreateOption(DiskCreateOption createOption) {
        this.createOption = createOption;
        return this;
    }

    public String storageAccountId() {
        return this.storageAccountId;
    }

    public CreationData withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    public ImageDiskReference imageReference() {
        return this.imageReference;
    }

    public CreationData withImageReference(ImageDiskReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    public ImageDiskReference galleryImageReference() {
        return this.galleryImageReference;
    }

    public CreationData withGalleryImageReference(ImageDiskReference galleryImageReference) {
        this.galleryImageReference = galleryImageReference;
        return this;
    }

    public String sourceUri() {
        return this.sourceUri;
    }

    public CreationData withSourceUri(String sourceUri) {
        this.sourceUri = sourceUri;
        return this;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public CreationData withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    public String sourceUniqueId() {
        return this.sourceUniqueId;
    }

    public Long uploadSizeBytes() {
        return this.uploadSizeBytes;
    }

    public CreationData withUploadSizeBytes(Long uploadSizeBytes) {
        this.uploadSizeBytes = uploadSizeBytes;
        return this;
    }

    public Integer logicalSectorSize() {
        return this.logicalSectorSize;
    }

    public CreationData withLogicalSectorSize(Integer logicalSectorSize) {
        this.logicalSectorSize = logicalSectorSize;
        return this;
    }

    public String securityDataUri() {
        return this.securityDataUri;
    }

    public CreationData withSecurityDataUri(String securityDataUri) {
        this.securityDataUri = securityDataUri;
        return this;
    }

    public String securityMetadataUri() {
        return this.securityMetadataUri;
    }

    public CreationData withSecurityMetadataUri(String securityMetadataUri) {
        this.securityMetadataUri = securityMetadataUri;
        return this;
    }

    public Boolean performancePlus() {
        return this.performancePlus;
    }

    public CreationData withPerformancePlus(Boolean performancePlus) {
        this.performancePlus = performancePlus;
        return this;
    }

    public String elasticSanResourceId() {
        return this.elasticSanResourceId;
    }

    public CreationData withElasticSanResourceId(String elasticSanResourceId) {
        this.elasticSanResourceId = elasticSanResourceId;
        return this;
    }

    public ProvisionedBandwidthCopyOption provisionedBandwidthCopySpeed() {
        return this.provisionedBandwidthCopySpeed;
    }

    public CreationData withProvisionedBandwidthCopySpeed(ProvisionedBandwidthCopyOption provisionedBandwidthCopySpeed) {
        this.provisionedBandwidthCopySpeed = provisionedBandwidthCopySpeed;
        return this;
    }

    public Long instantAccessDurationMinutes() {
        return this.instantAccessDurationMinutes;
    }

    public CreationData withInstantAccessDurationMinutes(Long instantAccessDurationMinutes) {
        this.instantAccessDurationMinutes = instantAccessDurationMinutes;
        return this;
    }

    public void validate() {
        if (this.createOption() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property createOption in model CreationData"));
        }
        if (this.imageReference() != null) {
            this.imageReference().validate();
        }
        if (this.galleryImageReference() != null) {
            this.galleryImageReference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createOption", this.createOption == null ? null : this.createOption.toString());
        jsonWriter.writeStringField("storageAccountId", this.storageAccountId);
        jsonWriter.writeJsonField("imageReference", (JsonSerializable)this.imageReference);
        jsonWriter.writeJsonField("galleryImageReference", (JsonSerializable)this.galleryImageReference);
        jsonWriter.writeStringField("sourceUri", this.sourceUri);
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId);
        jsonWriter.writeNumberField("uploadSizeBytes", (Number)this.uploadSizeBytes);
        jsonWriter.writeNumberField("logicalSectorSize", (Number)this.logicalSectorSize);
        jsonWriter.writeStringField("securityDataUri", this.securityDataUri);
        jsonWriter.writeStringField("securityMetadataUri", this.securityMetadataUri);
        jsonWriter.writeBooleanField("performancePlus", this.performancePlus);
        jsonWriter.writeStringField("elasticSanResourceId", this.elasticSanResourceId);
        jsonWriter.writeStringField("provisionedBandwidthCopySpeed", this.provisionedBandwidthCopySpeed == null ? null : this.provisionedBandwidthCopySpeed.toString());
        jsonWriter.writeNumberField("instantAccessDurationMinutes", (Number)this.instantAccessDurationMinutes);
        return jsonWriter.writeEndObject();
    }

    public static CreationData fromJson(JsonReader jsonReader) throws IOException {
        return (CreationData)jsonReader.readObject(reader -> {
            CreationData deserializedCreationData = new CreationData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createOption".equals(fieldName)) {
                    deserializedCreationData.createOption = DiskCreateOption.fromString(reader.getString());
                    continue;
                }
                if ("storageAccountId".equals(fieldName)) {
                    deserializedCreationData.storageAccountId = reader.getString();
                    continue;
                }
                if ("imageReference".equals(fieldName)) {
                    deserializedCreationData.imageReference = ImageDiskReference.fromJson(reader);
                    continue;
                }
                if ("galleryImageReference".equals(fieldName)) {
                    deserializedCreationData.galleryImageReference = ImageDiskReference.fromJson(reader);
                    continue;
                }
                if ("sourceUri".equals(fieldName)) {
                    deserializedCreationData.sourceUri = reader.getString();
                    continue;
                }
                if ("sourceResourceId".equals(fieldName)) {
                    deserializedCreationData.sourceResourceId = reader.getString();
                    continue;
                }
                if ("sourceUniqueId".equals(fieldName)) {
                    deserializedCreationData.sourceUniqueId = reader.getString();
                    continue;
                }
                if ("uploadSizeBytes".equals(fieldName)) {
                    deserializedCreationData.uploadSizeBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("logicalSectorSize".equals(fieldName)) {
                    deserializedCreationData.logicalSectorSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("securityDataUri".equals(fieldName)) {
                    deserializedCreationData.securityDataUri = reader.getString();
                    continue;
                }
                if ("securityMetadataUri".equals(fieldName)) {
                    deserializedCreationData.securityMetadataUri = reader.getString();
                    continue;
                }
                if ("performancePlus".equals(fieldName)) {
                    deserializedCreationData.performancePlus = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("elasticSanResourceId".equals(fieldName)) {
                    deserializedCreationData.elasticSanResourceId = reader.getString();
                    continue;
                }
                if ("provisionedBandwidthCopySpeed".equals(fieldName)) {
                    deserializedCreationData.provisionedBandwidthCopySpeed = ProvisionedBandwidthCopyOption.fromString(reader.getString());
                    continue;
                }
                if ("instantAccessDurationMinutes".equals(fieldName)) {
                    deserializedCreationData.instantAccessDurationMinutes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCreationData;
        });
    }
}

