/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.OSProfileProvisioningData;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMReimageParameters;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetReimageParameters
extends VirtualMachineScaleSetVMReimageParameters {
    private List<String> instanceIds;

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public VirtualMachineScaleSetReimageParameters withInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
        return this;
    }

    @Override
    public VirtualMachineScaleSetReimageParameters withForceUpdateOSDiskForEphemeral(Boolean forceUpdateOSDiskForEphemeral) {
        super.withForceUpdateOSDiskForEphemeral(forceUpdateOSDiskForEphemeral);
        return this;
    }

    @Override
    public VirtualMachineScaleSetReimageParameters withTempDisk(Boolean tempDisk) {
        super.withTempDisk(tempDisk);
        return this;
    }

    @Override
    public VirtualMachineScaleSetReimageParameters withExactVersion(String exactVersion) {
        super.withExactVersion(exactVersion);
        return this;
    }

    @Override
    public VirtualMachineScaleSetReimageParameters withOsProfile(OSProfileProvisioningData osProfile) {
        super.withOsProfile(osProfile);
        return this;
    }

    @Override
    public void validate() {
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("tempDisk", this.tempDisk());
        jsonWriter.writeStringField("exactVersion", this.exactVersion());
        jsonWriter.writeJsonField("osProfile", (JsonSerializable)this.osProfile());
        jsonWriter.writeBooleanField("forceUpdateOSDiskForEphemeral", this.forceUpdateOSDiskForEphemeral());
        jsonWriter.writeArrayField("instanceIds", this.instanceIds, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetReimageParameters fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetReimageParameters)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetReimageParameters deserializedVirtualMachineScaleSetReimageParameters = new VirtualMachineScaleSetReimageParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tempDisk".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetReimageParameters.withTempDisk((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("exactVersion".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetReimageParameters.withExactVersion(reader.getString());
                    continue;
                }
                if ("osProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetReimageParameters.withOsProfile(OSProfileProvisioningData.fromJson(reader));
                    continue;
                }
                if ("forceUpdateOSDiskForEphemeral".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetReimageParameters.withForceUpdateOSDiskForEphemeral((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("instanceIds".equals(fieldName)) {
                    List instanceIds;
                    deserializedVirtualMachineScaleSetReimageParameters.instanceIds = instanceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetReimageParameters;
        });
    }
}

