/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DataDiskImageEncryption;
import com.azure.resourcemanager.compute.models.OSDiskImageEncryption;
import java.io.IOException;
import java.util.List;

public final class EncryptionImages
implements JsonSerializable<EncryptionImages> {
    private OSDiskImageEncryption osDiskImage;
    private List<DataDiskImageEncryption> dataDiskImages;

    public OSDiskImageEncryption osDiskImage() {
        return this.osDiskImage;
    }

    public EncryptionImages withOsDiskImage(OSDiskImageEncryption osDiskImage) {
        this.osDiskImage = osDiskImage;
        return this;
    }

    public List<DataDiskImageEncryption> dataDiskImages() {
        return this.dataDiskImages;
    }

    public EncryptionImages withDataDiskImages(List<DataDiskImageEncryption> dataDiskImages) {
        this.dataDiskImages = dataDiskImages;
        return this;
    }

    public void validate() {
        if (this.osDiskImage() != null) {
            this.osDiskImage().validate();
        }
        if (this.dataDiskImages() != null) {
            this.dataDiskImages().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("osDiskImage", (JsonSerializable)this.osDiskImage);
        jsonWriter.writeArrayField("dataDiskImages", this.dataDiskImages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static EncryptionImages fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionImages)jsonReader.readObject(reader -> {
            EncryptionImages deserializedEncryptionImages = new EncryptionImages();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osDiskImage".equals(fieldName)) {
                    deserializedEncryptionImages.osDiskImage = OSDiskImageEncryption.fromJson(reader);
                    continue;
                }
                if ("dataDiskImages".equals(fieldName)) {
                    List dataDiskImages;
                    deserializedEncryptionImages.dataDiskImages = dataDiskImages = reader.readArray(reader1 -> DataDiskImageEncryption.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionImages;
        });
    }
}

