/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.CloudServiceRoleInner;
import java.io.IOException;
import java.util.List;

public final class CloudServiceRoleListResult
implements JsonSerializable<CloudServiceRoleListResult> {
    private List<CloudServiceRoleInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(CloudServiceRoleListResult.class);

    public List<CloudServiceRoleInner> value() {
        return this.value;
    }

    public CloudServiceRoleListResult withValue(List<CloudServiceRoleInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public CloudServiceRoleListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model CloudServiceRoleListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static CloudServiceRoleListResult fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServiceRoleListResult)jsonReader.readObject(reader -> {
            CloudServiceRoleListResult deserializedCloudServiceRoleListResult = new CloudServiceRoleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCloudServiceRoleListResult.value = value = reader.readArray(reader1 -> CloudServiceRoleInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedCloudServiceRoleListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServiceRoleListResult;
        });
    }
}

