/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApiError;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.azure.resourcemanager.compute.models.KeyForDiskEncryptionSet;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class EncryptionSetProperties
implements JsonSerializable<EncryptionSetProperties> {
    private DiskEncryptionSetType encryptionType;
    private KeyForDiskEncryptionSet activeKey;
    private List<KeyForDiskEncryptionSet> previousKeys;
    private String provisioningState;
    private Boolean rotationToLatestKeyVersionEnabled;
    private OffsetDateTime lastKeyRotationTimestamp;
    private ApiError autoKeyRotationError;
    private String federatedClientId;

    public DiskEncryptionSetType encryptionType() {
        return this.encryptionType;
    }

    public EncryptionSetProperties withEncryptionType(DiskEncryptionSetType encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    public KeyForDiskEncryptionSet activeKey() {
        return this.activeKey;
    }

    public EncryptionSetProperties withActiveKey(KeyForDiskEncryptionSet activeKey) {
        this.activeKey = activeKey;
        return this;
    }

    public List<KeyForDiskEncryptionSet> previousKeys() {
        return this.previousKeys;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Boolean rotationToLatestKeyVersionEnabled() {
        return this.rotationToLatestKeyVersionEnabled;
    }

    public EncryptionSetProperties withRotationToLatestKeyVersionEnabled(Boolean rotationToLatestKeyVersionEnabled) {
        this.rotationToLatestKeyVersionEnabled = rotationToLatestKeyVersionEnabled;
        return this;
    }

    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.lastKeyRotationTimestamp;
    }

    public ApiError autoKeyRotationError() {
        return this.autoKeyRotationError;
    }

    public String federatedClientId() {
        return this.federatedClientId;
    }

    public EncryptionSetProperties withFederatedClientId(String federatedClientId) {
        this.federatedClientId = federatedClientId;
        return this;
    }

    public void validate() {
        if (this.activeKey() != null) {
            this.activeKey().validate();
        }
        if (this.previousKeys() != null) {
            this.previousKeys().forEach(e -> e.validate());
        }
        if (this.autoKeyRotationError() != null) {
            this.autoKeyRotationError().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("encryptionType", this.encryptionType == null ? null : this.encryptionType.toString());
        jsonWriter.writeJsonField("activeKey", (JsonSerializable)this.activeKey);
        jsonWriter.writeBooleanField("rotationToLatestKeyVersionEnabled", this.rotationToLatestKeyVersionEnabled);
        jsonWriter.writeStringField("federatedClientId", this.federatedClientId);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionSetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionSetProperties)jsonReader.readObject(reader -> {
            EncryptionSetProperties deserializedEncryptionSetProperties = new EncryptionSetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("encryptionType".equals(fieldName)) {
                    deserializedEncryptionSetProperties.encryptionType = DiskEncryptionSetType.fromString(reader.getString());
                    continue;
                }
                if ("activeKey".equals(fieldName)) {
                    deserializedEncryptionSetProperties.activeKey = KeyForDiskEncryptionSet.fromJson(reader);
                    continue;
                }
                if ("previousKeys".equals(fieldName)) {
                    List previousKeys;
                    deserializedEncryptionSetProperties.previousKeys = previousKeys = reader.readArray(reader1 -> KeyForDiskEncryptionSet.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedEncryptionSetProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("rotationToLatestKeyVersionEnabled".equals(fieldName)) {
                    deserializedEncryptionSetProperties.rotationToLatestKeyVersionEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastKeyRotationTimestamp".equals(fieldName)) {
                    deserializedEncryptionSetProperties.lastKeyRotationTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("autoKeyRotationError".equals(fieldName)) {
                    deserializedEncryptionSetProperties.autoKeyRotationError = ApiError.fromJson(reader);
                    continue;
                }
                if ("federatedClientId".equals(fieldName)) {
                    deserializedEncryptionSetProperties.federatedClientId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionSetProperties;
        });
    }
}

