/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryApplicationScriptRebootBehavior;
import java.io.IOException;

public final class UserArtifactSettings
implements JsonSerializable<UserArtifactSettings> {
    private String packageFileName;
    private String configFileName;
    private GalleryApplicationScriptRebootBehavior scriptBehaviorAfterReboot;

    public String packageFileName() {
        return this.packageFileName;
    }

    public UserArtifactSettings withPackageFileName(String packageFileName) {
        this.packageFileName = packageFileName;
        return this;
    }

    public String configFileName() {
        return this.configFileName;
    }

    public UserArtifactSettings withConfigFileName(String configFileName) {
        this.configFileName = configFileName;
        return this;
    }

    public GalleryApplicationScriptRebootBehavior scriptBehaviorAfterReboot() {
        return this.scriptBehaviorAfterReboot;
    }

    public UserArtifactSettings withScriptBehaviorAfterReboot(GalleryApplicationScriptRebootBehavior scriptBehaviorAfterReboot) {
        this.scriptBehaviorAfterReboot = scriptBehaviorAfterReboot;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("packageFileName", this.packageFileName);
        jsonWriter.writeStringField("configFileName", this.configFileName);
        jsonWriter.writeStringField("scriptBehaviorAfterReboot", this.scriptBehaviorAfterReboot == null ? null : this.scriptBehaviorAfterReboot.toString());
        return jsonWriter.writeEndObject();
    }

    public static UserArtifactSettings fromJson(JsonReader jsonReader) throws IOException {
        return (UserArtifactSettings)jsonReader.readObject(reader -> {
            UserArtifactSettings deserializedUserArtifactSettings = new UserArtifactSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("packageFileName".equals(fieldName)) {
                    deserializedUserArtifactSettings.packageFileName = reader.getString();
                    continue;
                }
                if ("configFileName".equals(fieldName)) {
                    deserializedUserArtifactSettings.configFileName = reader.getString();
                    continue;
                }
                if ("scriptBehaviorAfterReboot".equals(fieldName)) {
                    deserializedUserArtifactSettings.scriptBehaviorAfterReboot = GalleryApplicationScriptRebootBehavior.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserArtifactSettings;
        });
    }
}

