/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DataDisk;
import com.azure.resourcemanager.compute.models.DiskControllerTypes;
import com.azure.resourcemanager.compute.models.ImageReference;
import com.azure.resourcemanager.compute.models.OSDisk;
import java.io.IOException;
import java.util.List;

public final class StorageProfile
implements JsonSerializable<StorageProfile> {
    private ImageReference imageReference;
    private OSDisk osDisk;
    private List<DataDisk> dataDisks;
    private DiskControllerTypes diskControllerType;

    public ImageReference imageReference() {
        return this.imageReference;
    }

    public StorageProfile withImageReference(ImageReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    public OSDisk osDisk() {
        return this.osDisk;
    }

    public StorageProfile withOsDisk(OSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    public List<DataDisk> dataDisks() {
        return this.dataDisks;
    }

    public StorageProfile withDataDisks(List<DataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    public DiskControllerTypes diskControllerType() {
        return this.diskControllerType;
    }

    public StorageProfile withDiskControllerType(DiskControllerTypes diskControllerType) {
        this.diskControllerType = diskControllerType;
        return this;
    }

    public void validate() {
        if (this.imageReference() != null) {
            this.imageReference().validate();
        }
        if (this.osDisk() != null) {
            this.osDisk().validate();
        }
        if (this.dataDisks() != null) {
            this.dataDisks().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("imageReference", (JsonSerializable)this.imageReference);
        jsonWriter.writeJsonField("osDisk", (JsonSerializable)this.osDisk);
        jsonWriter.writeArrayField("dataDisks", this.dataDisks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("diskControllerType", this.diskControllerType == null ? null : this.diskControllerType.toString());
        return jsonWriter.writeEndObject();
    }

    public static StorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return (StorageProfile)jsonReader.readObject(reader -> {
            StorageProfile deserializedStorageProfile = new StorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("imageReference".equals(fieldName)) {
                    deserializedStorageProfile.imageReference = ImageReference.fromJson(reader);
                    continue;
                }
                if ("osDisk".equals(fieldName)) {
                    deserializedStorageProfile.osDisk = OSDisk.fromJson(reader);
                    continue;
                }
                if ("dataDisks".equals(fieldName)) {
                    List dataDisks;
                    deserializedStorageProfile.dataDisks = dataDisks = reader.readArray(reader1 -> DataDisk.fromJson(reader1));
                    continue;
                }
                if ("diskControllerType".equals(fieldName)) {
                    deserializedStorageProfile.diskControllerType = DiskControllerTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageProfile;
        });
    }
}

