/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.SharedGalleryImageInner;
import java.io.IOException;
import java.util.List;

public final class SharedGalleryImageList
implements JsonSerializable<SharedGalleryImageList> {
    private List<SharedGalleryImageInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SharedGalleryImageList.class);

    public List<SharedGalleryImageInner> value() {
        return this.value;
    }

    public SharedGalleryImageList withValue(List<SharedGalleryImageInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public SharedGalleryImageList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SharedGalleryImageList"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SharedGalleryImageList fromJson(JsonReader jsonReader) throws IOException {
        return (SharedGalleryImageList)jsonReader.readObject(reader -> {
            SharedGalleryImageList deserializedSharedGalleryImageList = new SharedGalleryImageList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSharedGalleryImageList.value = value = reader.readArray(reader1 -> SharedGalleryImageInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSharedGalleryImageList.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharedGalleryImageList;
        });
    }
}

