/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ImageDataDisk;
import com.azure.resourcemanager.compute.models.ImageOSDisk;
import java.io.IOException;
import java.util.List;

public final class ImageStorageProfile
implements JsonSerializable<ImageStorageProfile> {
    private ImageOSDisk osDisk;
    private List<ImageDataDisk> dataDisks;
    private Boolean zoneResilient;

    public ImageOSDisk osDisk() {
        return this.osDisk;
    }

    public ImageStorageProfile withOsDisk(ImageOSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    public List<ImageDataDisk> dataDisks() {
        return this.dataDisks;
    }

    public ImageStorageProfile withDataDisks(List<ImageDataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    public Boolean zoneResilient() {
        return this.zoneResilient;
    }

    public ImageStorageProfile withZoneResilient(Boolean zoneResilient) {
        this.zoneResilient = zoneResilient;
        return this;
    }

    public void validate() {
        if (this.osDisk() != null) {
            this.osDisk().validate();
        }
        if (this.dataDisks() != null) {
            this.dataDisks().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("osDisk", (JsonSerializable)this.osDisk);
        jsonWriter.writeArrayField("dataDisks", this.dataDisks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("zoneResilient", this.zoneResilient);
        return jsonWriter.writeEndObject();
    }

    public static ImageStorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ImageStorageProfile)jsonReader.readObject(reader -> {
            ImageStorageProfile deserializedImageStorageProfile = new ImageStorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osDisk".equals(fieldName)) {
                    deserializedImageStorageProfile.osDisk = ImageOSDisk.fromJson(reader);
                    continue;
                }
                if ("dataDisks".equals(fieldName)) {
                    List dataDisks;
                    deserializedImageStorageProfile.dataDisks = dataDisks = reader.readArray(reader1 -> ImageDataDisk.fromJson(reader1));
                    continue;
                }
                if ("zoneResilient".equals(fieldName)) {
                    deserializedImageStorageProfile.zoneResilient = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageStorageProfile;
        });
    }
}

