/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryArtifactSafetyProfileBase;
import com.azure.resourcemanager.compute.models.PolicyViolation;
import java.io.IOException;
import java.util.List;

public final class GalleryImageVersionSafetyProfile
extends GalleryArtifactSafetyProfileBase {
    private Boolean reportedForPolicyViolation;
    private List<PolicyViolation> policyViolations;
    private Boolean blockDeletionBeforeEndOfLife;

    public Boolean reportedForPolicyViolation() {
        return this.reportedForPolicyViolation;
    }

    public List<PolicyViolation> policyViolations() {
        return this.policyViolations;
    }

    public Boolean blockDeletionBeforeEndOfLife() {
        return this.blockDeletionBeforeEndOfLife;
    }

    public GalleryImageVersionSafetyProfile withBlockDeletionBeforeEndOfLife(Boolean blockDeletionBeforeEndOfLife) {
        this.blockDeletionBeforeEndOfLife = blockDeletionBeforeEndOfLife;
        return this;
    }

    @Override
    public GalleryImageVersionSafetyProfile withAllowDeletionOfReplicatedLocations(Boolean allowDeletionOfReplicatedLocations) {
        super.withAllowDeletionOfReplicatedLocations(allowDeletionOfReplicatedLocations);
        return this;
    }

    @Override
    public void validate() {
        if (this.policyViolations() != null) {
            this.policyViolations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowDeletionOfReplicatedLocations", this.allowDeletionOfReplicatedLocations());
        jsonWriter.writeBooleanField("blockDeletionBeforeEndOfLife", this.blockDeletionBeforeEndOfLife);
        return jsonWriter.writeEndObject();
    }

    public static GalleryImageVersionSafetyProfile fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryImageVersionSafetyProfile)jsonReader.readObject(reader -> {
            GalleryImageVersionSafetyProfile deserializedGalleryImageVersionSafetyProfile = new GalleryImageVersionSafetyProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowDeletionOfReplicatedLocations".equals(fieldName)) {
                    deserializedGalleryImageVersionSafetyProfile.withAllowDeletionOfReplicatedLocations((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("reportedForPolicyViolation".equals(fieldName)) {
                    deserializedGalleryImageVersionSafetyProfile.reportedForPolicyViolation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("policyViolations".equals(fieldName)) {
                    List policyViolations;
                    deserializedGalleryImageVersionSafetyProfile.policyViolations = policyViolations = reader.readArray(reader1 -> PolicyViolation.fromJson(reader1));
                    continue;
                }
                if ("blockDeletionBeforeEndOfLife".equals(fieldName)) {
                    deserializedGalleryImageVersionSafetyProfile.blockDeletionBeforeEndOfLife = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryImageVersionSafetyProfile;
        });
    }
}

