/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.Disallowed;
import com.azure.resourcemanager.compute.models.GalleryImageIdentifier;
import com.azure.resourcemanager.compute.models.GalleryImagePropertiesProvisioningState;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.ImagePurchasePlan;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.RecommendedMachineConfiguration;
import com.azure.resourcemanager.compute.models.UpdateResourceDefinition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

@JsonFlatten
public class GalleryImageUpdate
extends UpdateResourceDefinition {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(GalleryImageUpdate.class);
    @JsonProperty(value="properties.description")
    private String description;
    @JsonProperty(value="properties.eula")
    private String eula;
    @JsonProperty(value="properties.privacyStatementUri")
    private String privacyStatementUri;
    @JsonProperty(value="properties.releaseNoteUri")
    private String releaseNoteUri;
    @JsonProperty(value="properties.osType")
    private OperatingSystemTypes osType;
    @JsonProperty(value="properties.osState")
    private OperatingSystemStateTypes osState;
    @JsonProperty(value="properties.hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="properties.endOfLifeDate")
    private OffsetDateTime endOfLifeDate;
    @JsonProperty(value="properties.identifier")
    private GalleryImageIdentifier identifier;
    @JsonProperty(value="properties.recommended")
    private RecommendedMachineConfiguration recommended;
    @JsonProperty(value="properties.disallowed")
    private Disallowed disallowed;
    @JsonProperty(value="properties.purchasePlan")
    private ImagePurchasePlan purchasePlan;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private GalleryImagePropertiesProvisioningState provisioningState;

    public String description() {
        return this.description;
    }

    public GalleryImageUpdate withDescription(String description) {
        this.description = description;
        return this;
    }

    public String eula() {
        return this.eula;
    }

    public GalleryImageUpdate withEula(String eula) {
        this.eula = eula;
        return this;
    }

    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    public GalleryImageUpdate withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    public String releaseNoteUri() {
        return this.releaseNoteUri;
    }

    public GalleryImageUpdate withReleaseNoteUri(String releaseNoteUri) {
        this.releaseNoteUri = releaseNoteUri;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public GalleryImageUpdate withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public OperatingSystemStateTypes osState() {
        return this.osState;
    }

    public GalleryImageUpdate withOsState(OperatingSystemStateTypes osState) {
        this.osState = osState;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public GalleryImageUpdate withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public GalleryImageUpdate withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public GalleryImageIdentifier identifier() {
        return this.identifier;
    }

    public GalleryImageUpdate withIdentifier(GalleryImageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public RecommendedMachineConfiguration recommended() {
        return this.recommended;
    }

    public GalleryImageUpdate withRecommended(RecommendedMachineConfiguration recommended) {
        this.recommended = recommended;
        return this;
    }

    public Disallowed disallowed() {
        return this.disallowed;
    }

    public GalleryImageUpdate withDisallowed(Disallowed disallowed) {
        this.disallowed = disallowed;
        return this;
    }

    public ImagePurchasePlan purchasePlan() {
        return this.purchasePlan;
    }

    public GalleryImageUpdate withPurchasePlan(ImagePurchasePlan purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public GalleryImagePropertiesProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public GalleryImageUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.identifier() != null) {
            this.identifier().validate();
        }
        if (this.recommended() != null) {
            this.recommended().validate();
        }
        if (this.disallowed() != null) {
            this.disallowed().validate();
        }
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
    }
}

