/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.AvailabilitySetsClient;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.AvailabilitySetInner;
import com.azure.resourcemanager.compute.implementation.AvailabilitySetImpl;
import com.azure.resourcemanager.compute.models.AvailabilitySet;
import com.azure.resourcemanager.compute.models.AvailabilitySetSkuTypes;
import com.azure.resourcemanager.compute.models.AvailabilitySets;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public class AvailabilitySetsImpl
extends GroupableResourcesImpl<AvailabilitySet, AvailabilitySetImpl, AvailabilitySetInner, AvailabilitySetsClient, ComputeManager>
implements AvailabilitySets {
    public AvailabilitySetsImpl(ComputeManager computeManager) {
        super((Object)((ComputeManagementClient)computeManager.serviceClient()).getAvailabilitySets(), (Manager)computeManager);
    }

    public PagedIterable<AvailabilitySet> list() {
        return PagedConverter.mapPage(((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getAvailabilitySets().list(), this::wrapModel);
    }

    public PagedFlux<AvailabilitySet> listAsync() {
        return PagedConverter.mapPage(((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getAvailabilitySets().listAsync(), this::wrapModel);
    }

    public PagedIterable<AvailabilitySet> listByResourceGroup(String groupName) {
        return this.wrapList(((AvailabilitySetsClient)this.inner()).listByResourceGroup(groupName));
    }

    public PagedFlux<AvailabilitySet> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((AvailabilitySetsClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    protected Mono<AvailabilitySetInner> getInnerAsync(String resourceGroupName, String name) {
        return ((AvailabilitySetsClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    public AvailabilitySetImpl define(String name) {
        return this.wrapModel(name).withSku(AvailabilitySetSkuTypes.ALIGNED);
    }

    protected Mono<Void> deleteInnerAsync(String groupName, String name) {
        return ((AvailabilitySetsClient)this.inner()).deleteAsync(groupName, name);
    }

    protected AvailabilitySetImpl wrapModel(String name) {
        return new AvailabilitySetImpl(name, new AvailabilitySetInner(), (ComputeManager)this.manager());
    }

    protected AvailabilitySetImpl wrapModel(AvailabilitySetInner availabilitySetInner) {
        if (availabilitySetInner == null) {
            return null;
        }
        return new AvailabilitySetImpl(availabilitySetInner.name(), availabilitySetInner, (ComputeManager)this.manager());
    }
}

