/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.AutomaticRepairsPolicy;
import com.azure.resourcemanager.compute.models.ExtendedLocation;
import com.azure.resourcemanager.compute.models.OrchestrationMode;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.ScaleInPolicy;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.UpgradePolicy;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualMachineScaleSetInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetInner.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="plan")
    private Plan plan;
    @JsonProperty(value="identity")
    private VirtualMachineScaleSetIdentity identity;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="properties.upgradePolicy")
    private UpgradePolicy upgradePolicy;
    @JsonProperty(value="properties.automaticRepairsPolicy")
    private AutomaticRepairsPolicy automaticRepairsPolicy;
    @JsonProperty(value="properties.virtualMachineProfile")
    private VirtualMachineScaleSetVMProfile virtualMachineProfile;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.overprovision")
    private Boolean overprovision;
    @JsonProperty(value="properties.doNotRunExtensionsOnOverprovisionedVMs")
    private Boolean doNotRunExtensionsOnOverprovisionedVMs;
    @JsonProperty(value="properties.uniqueId", access=JsonProperty.Access.WRITE_ONLY)
    private String uniqueId;
    @JsonProperty(value="properties.singlePlacementGroup")
    private Boolean singlePlacementGroup;
    @JsonProperty(value="properties.zoneBalance")
    private Boolean zoneBalance;
    @JsonProperty(value="properties.platformFaultDomainCount")
    private Integer platformFaultDomainCount;
    @JsonProperty(value="properties.proximityPlacementGroup")
    private SubResource proximityPlacementGroup;
    @JsonProperty(value="properties.hostGroup")
    private SubResource hostGroup;
    @JsonProperty(value="properties.additionalCapabilities")
    private AdditionalCapabilities additionalCapabilities;
    @JsonProperty(value="properties.scaleInPolicy")
    private ScaleInPolicy scaleInPolicy;
    @JsonProperty(value="properties.orchestrationMode")
    private OrchestrationMode orchestrationMode;

    public Sku sku() {
        return this.sku;
    }

    public VirtualMachineScaleSetInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Plan plan() {
        return this.plan;
    }

    public VirtualMachineScaleSetInner withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public VirtualMachineScaleSetIdentity identity() {
        return this.identity;
    }

    public VirtualMachineScaleSetInner withIdentity(VirtualMachineScaleSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public VirtualMachineScaleSetInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public VirtualMachineScaleSetInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public UpgradePolicy upgradePolicy() {
        return this.upgradePolicy;
    }

    public VirtualMachineScaleSetInner withUpgradePolicy(UpgradePolicy upgradePolicy) {
        this.upgradePolicy = upgradePolicy;
        return this;
    }

    public AutomaticRepairsPolicy automaticRepairsPolicy() {
        return this.automaticRepairsPolicy;
    }

    public VirtualMachineScaleSetInner withAutomaticRepairsPolicy(AutomaticRepairsPolicy automaticRepairsPolicy) {
        this.automaticRepairsPolicy = automaticRepairsPolicy;
        return this;
    }

    public VirtualMachineScaleSetVMProfile virtualMachineProfile() {
        return this.virtualMachineProfile;
    }

    public VirtualMachineScaleSetInner withVirtualMachineProfile(VirtualMachineScaleSetVMProfile virtualMachineProfile) {
        this.virtualMachineProfile = virtualMachineProfile;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Boolean overprovision() {
        return this.overprovision;
    }

    public VirtualMachineScaleSetInner withOverprovision(Boolean overprovision) {
        this.overprovision = overprovision;
        return this;
    }

    public Boolean doNotRunExtensionsOnOverprovisionedVMs() {
        return this.doNotRunExtensionsOnOverprovisionedVMs;
    }

    public VirtualMachineScaleSetInner withDoNotRunExtensionsOnOverprovisionedVMs(Boolean doNotRunExtensionsOnOverprovisionedVMs) {
        this.doNotRunExtensionsOnOverprovisionedVMs = doNotRunExtensionsOnOverprovisionedVMs;
        return this;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public Boolean singlePlacementGroup() {
        return this.singlePlacementGroup;
    }

    public VirtualMachineScaleSetInner withSinglePlacementGroup(Boolean singlePlacementGroup) {
        this.singlePlacementGroup = singlePlacementGroup;
        return this;
    }

    public Boolean zoneBalance() {
        return this.zoneBalance;
    }

    public VirtualMachineScaleSetInner withZoneBalance(Boolean zoneBalance) {
        this.zoneBalance = zoneBalance;
        return this;
    }

    public Integer platformFaultDomainCount() {
        return this.platformFaultDomainCount;
    }

    public VirtualMachineScaleSetInner withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        this.platformFaultDomainCount = platformFaultDomainCount;
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    public VirtualMachineScaleSetInner withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    public SubResource hostGroup() {
        return this.hostGroup;
    }

    public VirtualMachineScaleSetInner withHostGroup(SubResource hostGroup) {
        this.hostGroup = hostGroup;
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.additionalCapabilities;
    }

    public VirtualMachineScaleSetInner withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        this.additionalCapabilities = additionalCapabilities;
        return this;
    }

    public ScaleInPolicy scaleInPolicy() {
        return this.scaleInPolicy;
    }

    public VirtualMachineScaleSetInner withScaleInPolicy(ScaleInPolicy scaleInPolicy) {
        this.scaleInPolicy = scaleInPolicy;
        return this;
    }

    public OrchestrationMode orchestrationMode() {
        return this.orchestrationMode;
    }

    public VirtualMachineScaleSetInner withOrchestrationMode(OrchestrationMode orchestrationMode) {
        this.orchestrationMode = orchestrationMode;
        return this;
    }

    public VirtualMachineScaleSetInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualMachineScaleSetInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.upgradePolicy() != null) {
            this.upgradePolicy().validate();
        }
        if (this.automaticRepairsPolicy() != null) {
            this.automaticRepairsPolicy().validate();
        }
        if (this.virtualMachineProfile() != null) {
            this.virtualMachineProfile().validate();
        }
        if (this.additionalCapabilities() != null) {
            this.additionalCapabilities().validate();
        }
        if (this.scaleInPolicy() != null) {
            this.scaleInPolicy().validate();
        }
    }
}

