/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.ProxyOnlyResource;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

@JsonFlatten
public class DiskRestorePointInner
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DiskRestorePointInner.class);
    @JsonProperty(value="properties.timeCreated", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeCreated;
    @JsonProperty(value="properties.sourceResourceId", access=JsonProperty.Access.WRITE_ONLY)
    private String sourceResourceId;
    @JsonProperty(value="properties.osType", access=JsonProperty.Access.WRITE_ONLY)
    private OperatingSystemTypes osType;
    @JsonProperty(value="properties.hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="properties.purchasePlan")
    private PurchasePlanAutoGenerated purchasePlan;
    @JsonProperty(value="properties.familyId", access=JsonProperty.Access.WRITE_ONLY)
    private String familyId;
    @JsonProperty(value="properties.sourceUniqueId", access=JsonProperty.Access.WRITE_ONLY)
    private String sourceUniqueId;
    @JsonProperty(value="properties.encryption", access=JsonProperty.Access.WRITE_ONLY)
    private Encryption encryption;

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public DiskRestorePointInner withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    public DiskRestorePointInner withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public String familyId() {
        return this.familyId;
    }

    public String sourceUniqueId() {
        return this.sourceUniqueId;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }
}

