/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.GalleryArtifactPublishingProfileBase;
import com.azure.resourcemanager.compute.models.GalleryTargetExtendedLocation;
import com.azure.resourcemanager.compute.models.ReplicationMode;
import com.azure.resourcemanager.compute.models.StorageAccountType;
import com.azure.resourcemanager.compute.models.TargetRegion;
import com.azure.resourcemanager.compute.models.UserArtifactManage;
import com.azure.resourcemanager.compute.models.UserArtifactSettings;
import com.azure.resourcemanager.compute.models.UserArtifactSource;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class GalleryApplicationVersionPublishingProfile
extends GalleryArtifactPublishingProfileBase {
    @JsonProperty(value="source", required=true)
    private UserArtifactSource source;
    @JsonProperty(value="manageActions")
    private UserArtifactManage manageActions;
    @JsonProperty(value="settings")
    private UserArtifactSettings settings;
    @JsonProperty(value="advancedSettings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> advancedSettings;
    @JsonProperty(value="enableHealthCheck")
    private Boolean enableHealthCheck;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationVersionPublishingProfile.class);

    public UserArtifactSource source() {
        return this.source;
    }

    public GalleryApplicationVersionPublishingProfile withSource(UserArtifactSource source) {
        this.source = source;
        return this;
    }

    public UserArtifactManage manageActions() {
        return this.manageActions;
    }

    public GalleryApplicationVersionPublishingProfile withManageActions(UserArtifactManage manageActions) {
        this.manageActions = manageActions;
        return this;
    }

    public UserArtifactSettings settings() {
        return this.settings;
    }

    public GalleryApplicationVersionPublishingProfile withSettings(UserArtifactSettings settings) {
        this.settings = settings;
        return this;
    }

    public Map<String, String> advancedSettings() {
        return this.advancedSettings;
    }

    public GalleryApplicationVersionPublishingProfile withAdvancedSettings(Map<String, String> advancedSettings) {
        this.advancedSettings = advancedSettings;
        return this;
    }

    public Boolean enableHealthCheck() {
        return this.enableHealthCheck;
    }

    public GalleryApplicationVersionPublishingProfile withEnableHealthCheck(Boolean enableHealthCheck) {
        this.enableHealthCheck = enableHealthCheck;
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withTargetRegions(List<TargetRegion> targetRegions) {
        super.withTargetRegions(targetRegions);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withReplicaCount(Integer replicaCount) {
        super.withReplicaCount(replicaCount);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withExcludeFromLatest(Boolean excludeFromLatest) {
        super.withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        super.withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withStorageAccountType(StorageAccountType storageAccountType) {
        super.withStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withReplicationMode(ReplicationMode replicationMode) {
        super.withReplicationMode(replicationMode);
        return this;
    }

    @Override
    public GalleryApplicationVersionPublishingProfile withTargetExtendedLocations(List<GalleryTargetExtendedLocation> targetExtendedLocations) {
        super.withTargetExtendedLocations(targetExtendedLocations);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.source() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property source in model GalleryApplicationVersionPublishingProfile"));
        }
        this.source().validate();
        if (this.manageActions() != null) {
            this.manageActions().validate();
        }
        if (this.settings() != null) {
            this.settings().validate();
        }
    }
}

