/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.EncryptionImages;
import com.azure.resourcemanager.compute.models.StorageAccountType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class TargetRegion {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TargetRegion.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="regionalReplicaCount")
    private Integer regionalReplicaCount;
    @JsonProperty(value="storageAccountType")
    private StorageAccountType storageAccountType;
    @JsonProperty(value="encryption")
    private EncryptionImages encryption;

    public String name() {
        return this.name;
    }

    public TargetRegion withName(String name) {
        this.name = name;
        return this;
    }

    public Integer regionalReplicaCount() {
        return this.regionalReplicaCount;
    }

    public TargetRegion withRegionalReplicaCount(Integer regionalReplicaCount) {
        this.regionalReplicaCount = regionalReplicaCount;
        return this;
    }

    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    public TargetRegion withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    public EncryptionImages encryption() {
        return this.encryption;
    }

    public TargetRegion withEncryption(EncryptionImages encryption) {
        this.encryption = encryption;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model TargetRegion"));
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }
}

