/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetUpdateIpConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class VirtualMachineScaleSetUpdateNetworkConfiguration
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetUpdateNetworkConfiguration.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="properties.primary")
    private Boolean primary;
    @JsonProperty(value="properties.enableAcceleratedNetworking")
    private Boolean enableAcceleratedNetworking;
    @JsonProperty(value="properties.networkSecurityGroup")
    private SubResource networkSecurityGroup;
    @JsonProperty(value="properties.dnsSettings")
    private VirtualMachineScaleSetNetworkConfigurationDnsSettings dnsSettings;
    @JsonProperty(value="properties.ipConfigurations")
    private List<VirtualMachineScaleSetUpdateIpConfiguration> ipConfigurations;
    @JsonProperty(value="properties.enableIPForwarding")
    private Boolean enableIpForwarding;

    public String name() {
        return this.name;
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean primary() {
        return this.primary;
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public Boolean enableAcceleratedNetworking() {
        return this.enableAcceleratedNetworking;
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        this.enableAcceleratedNetworking = enableAcceleratedNetworking;
        return this;
    }

    public SubResource networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withNetworkSecurityGroup(SubResource networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    public VirtualMachineScaleSetNetworkConfigurationDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withDnsSettings(VirtualMachineScaleSetNetworkConfigurationDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public List<VirtualMachineScaleSetUpdateIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withIpConfigurations(List<VirtualMachineScaleSetUpdateIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public Boolean enableIpForwarding() {
        return this.enableIpForwarding;
    }

    public VirtualMachineScaleSetUpdateNetworkConfiguration withEnableIpForwarding(Boolean enableIpForwarding) {
        this.enableIpForwarding = enableIpForwarding;
        return this;
    }

    public void validate() {
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
    }
}

