/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.EncryptionSetIdentity;
import com.azure.resourcemanager.compute.models.KeyVaultAndKeyReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class DiskEncryptionSetInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DiskEncryptionSetInner.class);
    @JsonProperty(value="identity")
    private EncryptionSetIdentity identity;
    @JsonProperty(value="properties.activeKey")
    private KeyVaultAndKeyReference activeKey;
    @JsonProperty(value="properties.previousKeys", access=JsonProperty.Access.WRITE_ONLY)
    private List<KeyVaultAndKeyReference> previousKeys;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    public EncryptionSetIdentity identity() {
        return this.identity;
    }

    public DiskEncryptionSetInner withIdentity(EncryptionSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    public KeyVaultAndKeyReference activeKey() {
        return this.activeKey;
    }

    public DiskEncryptionSetInner withActiveKey(KeyVaultAndKeyReference activeKey) {
        this.activeKey = activeKey;
        return this;
    }

    public List<KeyVaultAndKeyReference> previousKeys() {
        return this.previousKeys;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.activeKey() != null) {
            this.activeKey().validate();
        }
        if (this.previousKeys() != null) {
            this.previousKeys().forEach(e -> e.validate());
        }
    }
}

