/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.MatchProcessingBehavior;
import com.azure.resourcemanager.cdn.models.SystemData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class RuleInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RuleInner.class);
    @JsonProperty(value="properties.order")
    private Integer order;
    @JsonProperty(value="properties.conditions")
    private List<DeliveryRuleCondition> conditions;
    @JsonProperty(value="properties.actions")
    private List<DeliveryRuleAction> actions;
    @JsonProperty(value="properties.matchProcessingBehavior")
    private MatchProcessingBehavior matchProcessingBehavior;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;
    @JsonProperty(value="properties.deploymentStatus", access=JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public Integer order() {
        return this.order;
    }

    public RuleInner withOrder(Integer order) {
        this.order = order;
        return this;
    }

    public List<DeliveryRuleCondition> conditions() {
        return this.conditions;
    }

    public RuleInner withConditions(List<DeliveryRuleCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public List<DeliveryRuleAction> actions() {
        return this.actions;
    }

    public RuleInner withActions(List<DeliveryRuleAction> actions) {
        this.actions = actions;
        return this;
    }

    public MatchProcessingBehavior matchProcessingBehavior() {
        return this.matchProcessingBehavior;
    }

    public RuleInner withMatchProcessingBehavior(MatchProcessingBehavior matchProcessingBehavior) {
        this.matchProcessingBehavior = matchProcessingBehavior;
        return this;
    }

    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public void validate() {
        if (this.conditions() != null) {
            this.conditions().forEach(e -> e.validate());
        }
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }
}

