/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.azure.resourcemanager.cdn.models.OriginGroupResourceState;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.ResponseBasedOriginErrorDetectionParameters;
import com.azure.resourcemanager.cdn.models.SystemData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class OriginGroupInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OriginGroupInner.class);
    @JsonProperty(value="properties.healthProbeSettings")
    private HealthProbeParameters healthProbeSettings;
    @JsonProperty(value="properties.origins")
    private List<ResourceReference> origins;
    @JsonProperty(value="properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes")
    private Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    @JsonProperty(value="properties.responseBasedOriginErrorDetectionSettings")
    private ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings;
    @JsonProperty(value="properties.resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private OriginGroupResourceState resourceState;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public HealthProbeParameters healthProbeSettings() {
        return this.healthProbeSettings;
    }

    public OriginGroupInner withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        this.healthProbeSettings = healthProbeSettings;
        return this;
    }

    public List<ResourceReference> origins() {
        return this.origins;
    }

    public OriginGroupInner withOrigins(List<ResourceReference> origins) {
        this.origins = origins;
        return this;
    }

    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    }

    public OriginGroupInner withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
        return this;
    }

    public ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings() {
        return this.responseBasedOriginErrorDetectionSettings;
    }

    public OriginGroupInner withResponseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings) {
        this.responseBasedOriginErrorDetectionSettings = responseBasedOriginErrorDetectionSettings;
        return this;
    }

    public OriginGroupResourceState resourceState() {
        return this.resourceState;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public void validate() {
        if (this.healthProbeSettings() != null) {
            this.healthProbeSettings().validate();
        }
        if (this.origins() != null) {
            this.origins().forEach(e -> e.validate());
        }
        if (this.responseBasedOriginErrorDetectionSettings() != null) {
            this.responseBasedOriginErrorDetectionSettings().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }
}

