/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.AfdDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.DomainValidationProperties;
import com.azure.resourcemanager.cdn.models.DomainValidationState;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SystemData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class AfdDomainInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AfdDomainInner.class);
    @JsonProperty(value="properties.tlsSettings")
    private AfdDomainHttpsParameters tlsSettings;
    @JsonProperty(value="properties.azureDnsZone")
    private ResourceReference azureDnsZone;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;
    @JsonProperty(value="properties.deploymentStatus", access=JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;
    @JsonProperty(value="properties.domainValidationState", access=JsonProperty.Access.WRITE_ONLY)
    private DomainValidationState domainValidationState;
    @JsonProperty(value="properties.hostName")
    private String hostname;
    @JsonProperty(value="properties.validationProperties", access=JsonProperty.Access.WRITE_ONLY)
    private DomainValidationProperties validationProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public AfdDomainHttpsParameters tlsSettings() {
        return this.tlsSettings;
    }

    public AfdDomainInner withTlsSettings(AfdDomainHttpsParameters tlsSettings) {
        this.tlsSettings = tlsSettings;
        return this;
    }

    public ResourceReference azureDnsZone() {
        return this.azureDnsZone;
    }

    public AfdDomainInner withAzureDnsZone(ResourceReference azureDnsZone) {
        this.azureDnsZone = azureDnsZone;
        return this;
    }

    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    public DomainValidationState domainValidationState() {
        return this.domainValidationState;
    }

    public String hostname() {
        return this.hostname;
    }

    public AfdDomainInner withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public DomainValidationProperties validationProperties() {
        return this.validationProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public void validate() {
        if (this.tlsSettings() != null) {
            this.tlsSettings().validate();
        }
        if (this.azureDnsZone() != null) {
            this.azureDnsZone().validate();
        }
        if (this.validationProperties() != null) {
            this.validationProperties().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }
}

