/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.cdn.fluent.CdnManagementClient;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientBuilder;
import com.azure.resourcemanager.cdn.implementation.CdnProfilesImpl;
import com.azure.resourcemanager.cdn.models.CdnProfiles;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;

public final class CdnManager
extends Manager<CdnManagementClient> {
    private CdnProfiles profiles;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static CdnManager authenticate(TokenCredential credential, AzureProfile profile) {
        return CdnManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    private static CdnManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        return new CdnManager(httpPipeline, profile);
    }

    private CdnManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new CdnManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public CdnProfiles profiles() {
        if (this.profiles == null) {
            this.profiles = new CdnProfilesImpl(this);
        }
        return this.profiles;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public CdnManager authenticate(TokenCredential credential, AzureProfile profile) {
            return CdnManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public CdnManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

