/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.ResourceUsageInner;
import java.io.IOException;
import java.util.List;

public final class ResourceUsageListResult
implements JsonSerializable<ResourceUsageListResult> {
    private List<ResourceUsageInner> value;
    private String nextLink;

    public List<ResourceUsageInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ResourceUsageListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ResourceUsageListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceUsageListResult)jsonReader.readObject(reader -> {
            ResourceUsageListResult deserializedResourceUsageListResult = new ResourceUsageListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedResourceUsageListResult.value = value = reader.readArray(reader1 -> ResourceUsageInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedResourceUsageListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceUsageListResult;
        });
    }
}

