/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.DestinationProtocol;
import com.azure.resourcemanager.cdn.models.RedirectType;
import java.io.IOException;

public final class UrlRedirectActionParameters
implements JsonSerializable<UrlRedirectActionParameters> {
    private String typeName = "DeliveryRuleUrlRedirectActionParameters";
    private RedirectType redirectType;
    private DestinationProtocol destinationProtocol;
    private String customPath;
    private String customHostname;
    private String customQueryString;
    private String customFragment;
    private static final ClientLogger LOGGER = new ClientLogger(UrlRedirectActionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public UrlRedirectActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public RedirectType redirectType() {
        return this.redirectType;
    }

    public UrlRedirectActionParameters withRedirectType(RedirectType redirectType) {
        this.redirectType = redirectType;
        return this;
    }

    public DestinationProtocol destinationProtocol() {
        return this.destinationProtocol;
    }

    public UrlRedirectActionParameters withDestinationProtocol(DestinationProtocol destinationProtocol) {
        this.destinationProtocol = destinationProtocol;
        return this;
    }

    public String customPath() {
        return this.customPath;
    }

    public UrlRedirectActionParameters withCustomPath(String customPath) {
        this.customPath = customPath;
        return this;
    }

    public String customHostname() {
        return this.customHostname;
    }

    public UrlRedirectActionParameters withCustomHostname(String customHostname) {
        this.customHostname = customHostname;
        return this;
    }

    public String customQueryString() {
        return this.customQueryString;
    }

    public UrlRedirectActionParameters withCustomQueryString(String customQueryString) {
        this.customQueryString = customQueryString;
        return this;
    }

    public String customFragment() {
        return this.customFragment;
    }

    public UrlRedirectActionParameters withCustomFragment(String customFragment) {
        this.customFragment = customFragment;
        return this;
    }

    public void validate() {
        if (this.redirectType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property redirectType in model UrlRedirectActionParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("redirectType", this.redirectType == null ? null : this.redirectType.toString());
        jsonWriter.writeStringField("destinationProtocol", this.destinationProtocol == null ? null : this.destinationProtocol.toString());
        jsonWriter.writeStringField("customPath", this.customPath);
        jsonWriter.writeStringField("customHostname", this.customHostname);
        jsonWriter.writeStringField("customQueryString", this.customQueryString);
        jsonWriter.writeStringField("customFragment", this.customFragment);
        return jsonWriter.writeEndObject();
    }

    public static UrlRedirectActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (UrlRedirectActionParameters)jsonReader.readObject(reader -> {
            UrlRedirectActionParameters deserializedUrlRedirectActionParameters = new UrlRedirectActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("redirectType".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.redirectType = RedirectType.fromString(reader.getString());
                    continue;
                }
                if ("destinationProtocol".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.destinationProtocol = DestinationProtocol.fromString(reader.getString());
                    continue;
                }
                if ("customPath".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.customPath = reader.getString();
                    continue;
                }
                if ("customHostname".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.customHostname = reader.getString();
                    continue;
                }
                if ("customQueryString".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.customQueryString = reader.getString();
                    continue;
                }
                if ("customFragment".equals(fieldName)) {
                    deserializedUrlRedirectActionParameters.customFragment = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUrlRedirectActionParameters;
        });
    }
}

