/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.RuleCacheBehavior;
import com.azure.resourcemanager.cdn.models.RuleIsCompressionEnabled;
import com.azure.resourcemanager.cdn.models.RuleQueryStringCachingBehavior;
import java.io.IOException;

public final class CacheConfiguration
implements JsonSerializable<CacheConfiguration> {
    private RuleQueryStringCachingBehavior queryStringCachingBehavior;
    private String queryParameters;
    private RuleIsCompressionEnabled isCompressionEnabled;
    private RuleCacheBehavior cacheBehavior;
    private String cacheDuration;

    public RuleQueryStringCachingBehavior queryStringCachingBehavior() {
        return this.queryStringCachingBehavior;
    }

    public CacheConfiguration withQueryStringCachingBehavior(RuleQueryStringCachingBehavior queryStringCachingBehavior) {
        this.queryStringCachingBehavior = queryStringCachingBehavior;
        return this;
    }

    public String queryParameters() {
        return this.queryParameters;
    }

    public CacheConfiguration withQueryParameters(String queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public RuleIsCompressionEnabled isCompressionEnabled() {
        return this.isCompressionEnabled;
    }

    public CacheConfiguration withIsCompressionEnabled(RuleIsCompressionEnabled isCompressionEnabled) {
        this.isCompressionEnabled = isCompressionEnabled;
        return this;
    }

    public RuleCacheBehavior cacheBehavior() {
        return this.cacheBehavior;
    }

    public CacheConfiguration withCacheBehavior(RuleCacheBehavior cacheBehavior) {
        this.cacheBehavior = cacheBehavior;
        return this;
    }

    public String cacheDuration() {
        return this.cacheDuration;
    }

    public CacheConfiguration withCacheDuration(String cacheDuration) {
        this.cacheDuration = cacheDuration;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queryStringCachingBehavior", this.queryStringCachingBehavior == null ? null : this.queryStringCachingBehavior.toString());
        jsonWriter.writeStringField("queryParameters", this.queryParameters);
        jsonWriter.writeStringField("isCompressionEnabled", this.isCompressionEnabled == null ? null : this.isCompressionEnabled.toString());
        jsonWriter.writeStringField("cacheBehavior", this.cacheBehavior == null ? null : this.cacheBehavior.toString());
        jsonWriter.writeStringField("cacheDuration", this.cacheDuration);
        return jsonWriter.writeEndObject();
    }

    public static CacheConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (CacheConfiguration)jsonReader.readObject(reader -> {
            CacheConfiguration deserializedCacheConfiguration = new CacheConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queryStringCachingBehavior".equals(fieldName)) {
                    deserializedCacheConfiguration.queryStringCachingBehavior = RuleQueryStringCachingBehavior.fromString(reader.getString());
                    continue;
                }
                if ("queryParameters".equals(fieldName)) {
                    deserializedCacheConfiguration.queryParameters = reader.getString();
                    continue;
                }
                if ("isCompressionEnabled".equals(fieldName)) {
                    deserializedCacheConfiguration.isCompressionEnabled = RuleIsCompressionEnabled.fromString(reader.getString());
                    continue;
                }
                if ("cacheBehavior".equals(fieldName)) {
                    deserializedCacheConfiguration.cacheBehavior = RuleCacheBehavior.fromString(reader.getString());
                    continue;
                }
                if ("cacheDuration".equals(fieldName)) {
                    deserializedCacheConfiguration.cacheDuration = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheConfiguration;
        });
    }
}

