/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.HostnameOperator;
import com.azure.resourcemanager.cdn.models.Transform;
import java.io.IOException;
import java.util.List;

public final class HostnameMatchConditionParameters
implements JsonSerializable<HostnameMatchConditionParameters> {
    private String typeName = "DeliveryRuleHostNameConditionParameters";
    private HostnameOperator operator;
    private Boolean negateCondition;
    private List<String> matchValues;
    private List<Transform> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(HostnameMatchConditionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public HostnameMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public HostnameOperator operator() {
        return this.operator;
    }

    public HostnameMatchConditionParameters withOperator(HostnameOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public HostnameMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<String> matchValues() {
        return this.matchValues;
    }

    public HostnameMatchConditionParameters withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    public HostnameMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model HostnameMatchConditionParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static HostnameMatchConditionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (HostnameMatchConditionParameters)jsonReader.readObject(reader -> {
            HostnameMatchConditionParameters deserializedHostnameMatchConditionParameters = new HostnameMatchConditionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operator".equals(fieldName)) {
                    deserializedHostnameMatchConditionParameters.operator = HostnameOperator.fromString(reader.getString());
                    continue;
                }
                if ("negateCondition".equals(fieldName)) {
                    deserializedHostnameMatchConditionParameters.negateCondition = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List matchValues;
                    deserializedHostnameMatchConditionParameters.matchValues = matchValues = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List transforms;
                    deserializedHostnameMatchConditionParameters.transforms = transforms = reader.readArray(reader1 -> Transform.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHostnameMatchConditionParameters;
        });
    }
}

