/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleActionValue;
import com.azure.resourcemanager.cdn.models.HeaderActionParameters;
import java.io.IOException;

public final class DeliveryRuleRequestHeaderAction
extends DeliveryRuleAction {
    private DeliveryRuleActionValue name = DeliveryRuleActionValue.MODIFY_REQUEST_HEADER;
    private HeaderActionParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRuleRequestHeaderAction.class);

    @Override
    public DeliveryRuleActionValue name() {
        return this.name;
    }

    public HeaderActionParameters parameters() {
        return this.parameters;
    }

    public DeliveryRuleRequestHeaderAction withParameters(HeaderActionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameters in model DeliveryRuleRequestHeaderAction"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeliveryRuleRequestHeaderAction fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryRuleRequestHeaderAction)jsonReader.readObject(reader -> {
            DeliveryRuleRequestHeaderAction deserializedDeliveryRuleRequestHeaderAction = new DeliveryRuleRequestHeaderAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    deserializedDeliveryRuleRequestHeaderAction.parameters = HeaderActionParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleRequestHeaderAction.name = DeliveryRuleActionValue.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryRuleRequestHeaderAction;
        });
    }
}

