/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.QueryStringBehavior;
import java.io.IOException;

public final class CacheKeyQueryStringActionParameters
implements JsonSerializable<CacheKeyQueryStringActionParameters> {
    private String typeName = "DeliveryRuleCacheKeyQueryStringBehaviorActionParameters";
    private QueryStringBehavior queryStringBehavior;
    private String queryParameters;
    private static final ClientLogger LOGGER = new ClientLogger(CacheKeyQueryStringActionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public CacheKeyQueryStringActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public QueryStringBehavior queryStringBehavior() {
        return this.queryStringBehavior;
    }

    public CacheKeyQueryStringActionParameters withQueryStringBehavior(QueryStringBehavior queryStringBehavior) {
        this.queryStringBehavior = queryStringBehavior;
        return this;
    }

    public String queryParameters() {
        return this.queryParameters;
    }

    public CacheKeyQueryStringActionParameters withQueryParameters(String queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public void validate() {
        if (this.queryStringBehavior() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property queryStringBehavior in model CacheKeyQueryStringActionParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("queryStringBehavior", this.queryStringBehavior == null ? null : this.queryStringBehavior.toString());
        jsonWriter.writeStringField("queryParameters", this.queryParameters);
        return jsonWriter.writeEndObject();
    }

    public static CacheKeyQueryStringActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CacheKeyQueryStringActionParameters)jsonReader.readObject(reader -> {
            CacheKeyQueryStringActionParameters deserializedCacheKeyQueryStringActionParameters = new CacheKeyQueryStringActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queryStringBehavior".equals(fieldName)) {
                    deserializedCacheKeyQueryStringActionParameters.queryStringBehavior = QueryStringBehavior.fromString(reader.getString());
                    continue;
                }
                if ("queryParameters".equals(fieldName)) {
                    deserializedCacheKeyQueryStringActionParameters.queryParameters = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheKeyQueryStringActionParameters;
        });
    }
}

