/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.AfdEndpointsClient;
import com.azure.resourcemanager.cdn.fluent.models.AfdEndpointInner;
import com.azure.resourcemanager.cdn.fluent.models.UsageInner;
import com.azure.resourcemanager.cdn.fluent.models.ValidateCustomDomainOutputInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.AfdEndpointListResult;
import com.azure.resourcemanager.cdn.models.AfdEndpointUpdateParameters;
import com.azure.resourcemanager.cdn.models.AfdPurgeParameters;
import com.azure.resourcemanager.cdn.models.UsagesListResult;
import com.azure.resourcemanager.cdn.models.ValidateCustomDomainInput;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AfdEndpointsClientImpl
implements AfdEndpointsClient {
    private final AfdEndpointsService service;
    private final CdnManagementClientImpl client;

    AfdEndpointsClientImpl(CdnManagementClientImpl client) {
        this.service = (AfdEndpointsService)RestProxy.create(AfdEndpointsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AfdEndpointInner>> listByProfileSinglePageAsync(String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProfile(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdEndpointListResult)res.getValue()).value(), ((AfdEndpointListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AfdEndpointInner>> listByProfileSinglePageAsync(String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProfile(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdEndpointListResult)res.getValue()).value(), ((AfdEndpointListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AfdEndpointInner> listByProfileAsync(String resourceGroupName, String profileName) {
        return new PagedFlux(() -> this.listByProfileSinglePageAsync(resourceGroupName, profileName), nextLink -> this.listByProfileNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AfdEndpointInner> listByProfileAsync(String resourceGroupName, String profileName, Context context) {
        return new PagedFlux(() -> this.listByProfileSinglePageAsync(resourceGroupName, profileName, context), nextLink -> this.listByProfileNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AfdEndpointInner> listByProfile(String resourceGroupName, String profileName) {
        return new PagedIterable(this.listByProfileAsync(resourceGroupName, profileName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AfdEndpointInner> listByProfile(String resourceGroupName, String profileName, Context context) {
        return new PagedIterable(this.listByProfileAsync(resourceGroupName, profileName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AfdEndpointInner>> getWithResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AfdEndpointInner>> getWithResponseAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AfdEndpointInner> getAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.getWithResponseAsync(resourceGroupName, profileName, endpointName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AfdEndpointInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AfdEndpointInner> getWithResponse(String resourceGroupName, String profileName, String endpointName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, profileName, endpointName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AfdEndpointInner get(String resourceGroupName, String profileName, String endpointName) {
        return (AfdEndpointInner)((Object)this.getWithResponse(resourceGroupName, profileName, endpointName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointInner endpointParam) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpointParam == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointParam is required and cannot be null."));
        }
        endpointParam.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), endpointParam, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointInner endpointParam, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpointParam == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointParam is required and cannot be null."));
        }
        endpointParam.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), endpointParam, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AfdEndpointInner>, AfdEndpointInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointInner endpointParam) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, endpointName, endpointParam);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdEndpointInner.class), (Type)((Object)AfdEndpointInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AfdEndpointInner>, AfdEndpointInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointInner endpointParam, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, endpointName, endpointParam, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdEndpointInner.class), (Type)((Object)AfdEndpointInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AfdEndpointInner>, AfdEndpointInner> beginCreate(String resourceGroupName, String profileName, String endpointName, AfdEndpointInner endpointParam) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, endpointParam).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AfdEndpointInner>, AfdEndpointInner> beginCreate(String resourceGroupName, String profileName, String endpointName, AfdEndpointInner endpointParam, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, endpointParam, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AfdEndpointInner> createAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointInner endpointParam) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, endpointParam).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AfdEndpointInner> createAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointInner endpointParam, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, endpointParam, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AfdEndpointInner create(String resourceGroupName, String profileName, String endpointName, AfdEndpointInner endpointParam) {
        return (AfdEndpointInner)((Object)this.createAsync(resourceGroupName, profileName, endpointName, endpointParam).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AfdEndpointInner create(String resourceGroupName, String profileName, String endpointName, AfdEndpointInner endpointParam, Context context) {
        return (AfdEndpointInner)((Object)this.createAsync(resourceGroupName, profileName, endpointName, endpointParam, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointUpdateParameters endpointUpdateProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpointUpdateProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointUpdateProperties is required and cannot be null."));
        }
        endpointUpdateProperties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), endpointUpdateProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointUpdateParameters endpointUpdateProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpointUpdateProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointUpdateProperties is required and cannot be null."));
        }
        endpointUpdateProperties.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), endpointUpdateProperties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AfdEndpointInner>, AfdEndpointInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointUpdateParameters endpointUpdateProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdEndpointInner.class), (Type)((Object)AfdEndpointInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AfdEndpointInner>, AfdEndpointInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointUpdateParameters endpointUpdateProperties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdEndpointInner.class), (Type)((Object)AfdEndpointInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AfdEndpointInner>, AfdEndpointInner> beginUpdate(String resourceGroupName, String profileName, String endpointName, AfdEndpointUpdateParameters endpointUpdateProperties) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AfdEndpointInner>, AfdEndpointInner> beginUpdate(String resourceGroupName, String profileName, String endpointName, AfdEndpointUpdateParameters endpointUpdateProperties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AfdEndpointInner> updateAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointUpdateParameters endpointUpdateProperties) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AfdEndpointInner> updateAsync(String resourceGroupName, String profileName, String endpointName, AfdEndpointUpdateParameters endpointUpdateProperties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AfdEndpointInner update(String resourceGroupName, String profileName, String endpointName, AfdEndpointUpdateParameters endpointUpdateProperties) {
        return (AfdEndpointInner)((Object)this.updateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AfdEndpointInner update(String resourceGroupName, String profileName, String endpointName, AfdEndpointUpdateParameters endpointUpdateProperties, Context context) {
        return (AfdEndpointInner)((Object)this.updateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, endpointName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, endpointName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String endpointName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String endpointName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String endpointName) {
        this.deleteAsync(resourceGroupName, profileName, endpointName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String endpointName, Context context) {
        this.deleteAsync(resourceGroupName, profileName, endpointName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> purgeContentWithResponseAsync(String resourceGroupName, String profileName, String endpointName, AfdPurgeParameters contents) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (contents == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contents is required and cannot be null."));
        }
        contents.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.purgeContent(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), contents, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> purgeContentWithResponseAsync(String resourceGroupName, String profileName, String endpointName, AfdPurgeParameters contents, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (contents == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contents is required and cannot be null."));
        }
        contents.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.purgeContent(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), contents, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginPurgeContentAsync(String resourceGroupName, String profileName, String endpointName, AfdPurgeParameters contents) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.purgeContentWithResponseAsync(resourceGroupName, profileName, endpointName, contents);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginPurgeContentAsync(String resourceGroupName, String profileName, String endpointName, AfdPurgeParameters contents, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.purgeContentWithResponseAsync(resourceGroupName, profileName, endpointName, contents, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPurgeContent(String resourceGroupName, String profileName, String endpointName, AfdPurgeParameters contents) {
        return this.beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contents).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginPurgeContent(String resourceGroupName, String profileName, String endpointName, AfdPurgeParameters contents, Context context) {
        return this.beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contents, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeContentAsync(String resourceGroupName, String profileName, String endpointName, AfdPurgeParameters contents) {
        return this.beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contents).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> purgeContentAsync(String resourceGroupName, String profileName, String endpointName, AfdPurgeParameters contents, Context context) {
        return this.beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contents, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeContent(String resourceGroupName, String profileName, String endpointName, AfdPurgeParameters contents) {
        this.purgeContentAsync(resourceGroupName, profileName, endpointName, contents).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeContent(String resourceGroupName, String profileName, String endpointName, AfdPurgeParameters contents, Context context) {
        this.purgeContentAsync(resourceGroupName, profileName, endpointName, contents, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UsageInner>> listResourceUsageSinglePageAsync(String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listResourceUsage(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesListResult)res.getValue()).value(), ((UsagesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UsageInner>> listResourceUsageSinglePageAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listResourceUsage(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesListResult)res.getValue()).value(), ((UsagesListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<UsageInner> listResourceUsageAsync(String resourceGroupName, String profileName, String endpointName) {
        return new PagedFlux(() -> this.listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName), nextLink -> this.listResourceUsageNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<UsageInner> listResourceUsageAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedFlux(() -> this.listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName, context), nextLink -> this.listResourceUsageNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<UsageInner> listResourceUsage(String resourceGroupName, String profileName, String endpointName) {
        return new PagedIterable(this.listResourceUsageAsync(resourceGroupName, profileName, endpointName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<UsageInner> listResourceUsage(String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedIterable(this.listResourceUsageAsync(resourceGroupName, profileName, endpointName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ValidateCustomDomainOutputInner>> validateCustomDomainWithResponseAsync(String resourceGroupName, String profileName, String endpointName, ValidateCustomDomainInput customDomainProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (customDomainProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainProperties is required and cannot be null."));
        }
        customDomainProperties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateCustomDomain(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomainProperties, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ValidateCustomDomainOutputInner>> validateCustomDomainWithResponseAsync(String resourceGroupName, String profileName, String endpointName, ValidateCustomDomainInput customDomainProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (customDomainProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainProperties is required and cannot be null."));
        }
        customDomainProperties.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateCustomDomain(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomainProperties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ValidateCustomDomainOutputInner> validateCustomDomainAsync(String resourceGroupName, String profileName, String endpointName, ValidateCustomDomainInput customDomainProperties) {
        return this.validateCustomDomainWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainProperties).flatMap(res -> Mono.justOrEmpty((Object)((ValidateCustomDomainOutputInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ValidateCustomDomainOutputInner> validateCustomDomainWithResponse(String resourceGroupName, String profileName, String endpointName, ValidateCustomDomainInput customDomainProperties, Context context) {
        return (Response)this.validateCustomDomainWithResponseAsync(resourceGroupName, profileName, endpointName, customDomainProperties, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ValidateCustomDomainOutputInner validateCustomDomain(String resourceGroupName, String profileName, String endpointName, ValidateCustomDomainInput customDomainProperties) {
        return (ValidateCustomDomainOutputInner)this.validateCustomDomainWithResponse(resourceGroupName, profileName, endpointName, customDomainProperties, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AfdEndpointInner>> listByProfileNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProfileNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdEndpointListResult)res.getValue()).value(), ((AfdEndpointListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AfdEndpointInner>> listByProfileNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProfileNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdEndpointListResult)res.getValue()).value(), ((AfdEndpointListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UsageInner>> listResourceUsageNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listResourceUsageNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesListResult)res.getValue()).value(), ((UsagesListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UsageInner>> listResourceUsageNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listResourceUsageNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesListResult)res.getValue()).value(), ((UsagesListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientA")
    public static interface AfdEndpointsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AfdEndpointListResult>> listByProfile(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AfdEndpointInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AfdEndpointInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AfdEndpointUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/purge")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> purgeContent(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AfdPurgeParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/usages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<UsagesListResult>> listResourceUsage(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}/validateCustomDomain")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ValidateCustomDomainOutputInner>> validateCustomDomain(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ValidateCustomDomainInput var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AfdEndpointListResult>> listByProfileNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<UsagesListResult>> listResourceUsageNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

