/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import com.azure.resourcemanager.cdn.models.MatchProcessingBehavior;
import java.io.IOException;
import java.util.List;

public class RuleUpdatePropertiesParameters
implements JsonSerializable<RuleUpdatePropertiesParameters> {
    private String ruleSetName;
    private Integer order;
    private List<DeliveryRuleCondition> conditions;
    private List<DeliveryRuleAction> actions;
    private MatchProcessingBehavior matchProcessingBehavior;

    public String ruleSetName() {
        return this.ruleSetName;
    }

    RuleUpdatePropertiesParameters withRuleSetName(String ruleSetName) {
        this.ruleSetName = ruleSetName;
        return this;
    }

    public Integer order() {
        return this.order;
    }

    public RuleUpdatePropertiesParameters withOrder(Integer order) {
        this.order = order;
        return this;
    }

    public List<DeliveryRuleCondition> conditions() {
        return this.conditions;
    }

    public RuleUpdatePropertiesParameters withConditions(List<DeliveryRuleCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public List<DeliveryRuleAction> actions() {
        return this.actions;
    }

    public RuleUpdatePropertiesParameters withActions(List<DeliveryRuleAction> actions) {
        this.actions = actions;
        return this;
    }

    public MatchProcessingBehavior matchProcessingBehavior() {
        return this.matchProcessingBehavior;
    }

    public RuleUpdatePropertiesParameters withMatchProcessingBehavior(MatchProcessingBehavior matchProcessingBehavior) {
        this.matchProcessingBehavior = matchProcessingBehavior;
        return this;
    }

    public void validate() {
        if (this.conditions() != null) {
            this.conditions().forEach(e -> e.validate());
        }
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("order", (Number)this.order);
        jsonWriter.writeArrayField("conditions", this.conditions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("matchProcessingBehavior", this.matchProcessingBehavior == null ? null : this.matchProcessingBehavior.toString());
        return jsonWriter.writeEndObject();
    }

    public static RuleUpdatePropertiesParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RuleUpdatePropertiesParameters)jsonReader.readObject(reader -> {
            RuleUpdatePropertiesParameters deserializedRuleUpdatePropertiesParameters = new RuleUpdatePropertiesParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleSetName".equals(fieldName)) {
                    deserializedRuleUpdatePropertiesParameters.ruleSetName = reader.getString();
                    continue;
                }
                if ("order".equals(fieldName)) {
                    deserializedRuleUpdatePropertiesParameters.order = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("conditions".equals(fieldName)) {
                    List conditions;
                    deserializedRuleUpdatePropertiesParameters.conditions = conditions = reader.readArray(reader1 -> DeliveryRuleCondition.fromJson(reader1));
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedRuleUpdatePropertiesParameters.actions = actions = reader.readArray(reader1 -> DeliveryRuleAction.fromJson(reader1));
                    continue;
                }
                if ("matchProcessingBehavior".equals(fieldName)) {
                    deserializedRuleUpdatePropertiesParameters.matchProcessingBehavior = MatchProcessingBehavior.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRuleUpdatePropertiesParameters;
        });
    }
}

