/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.OriginUpdatePropertiesParameters;
import com.azure.resourcemanager.cdn.models.OriginProvisioningState;
import com.azure.resourcemanager.cdn.models.OriginResourceState;
import com.azure.resourcemanager.cdn.models.PrivateEndpointStatus;
import java.io.IOException;

public final class OriginProperties
extends OriginUpdatePropertiesParameters {
    private OriginResourceState resourceState;
    private OriginProvisioningState provisioningState;
    private PrivateEndpointStatus privateEndpointStatus;

    public OriginResourceState resourceState() {
        return this.resourceState;
    }

    public OriginProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PrivateEndpointStatus privateEndpointStatus() {
        return this.privateEndpointStatus;
    }

    @Override
    public OriginProperties withHostname(String hostname) {
        super.withHostname(hostname);
        return this;
    }

    @Override
    public OriginProperties withHttpPort(Integer httpPort) {
        super.withHttpPort(httpPort);
        return this;
    }

    @Override
    public OriginProperties withHttpsPort(Integer httpsPort) {
        super.withHttpsPort(httpsPort);
        return this;
    }

    @Override
    public OriginProperties withOriginHostHeader(String originHostHeader) {
        super.withOriginHostHeader(originHostHeader);
        return this;
    }

    @Override
    public OriginProperties withPriority(Integer priority) {
        super.withPriority(priority);
        return this;
    }

    @Override
    public OriginProperties withWeight(Integer weight) {
        super.withWeight(weight);
        return this;
    }

    @Override
    public OriginProperties withEnabled(Boolean enabled) {
        super.withEnabled(enabled);
        return this;
    }

    @Override
    public OriginProperties withPrivateLinkAlias(String privateLinkAlias) {
        super.withPrivateLinkAlias(privateLinkAlias);
        return this;
    }

    @Override
    public OriginProperties withPrivateLinkResourceId(String privateLinkResourceId) {
        super.withPrivateLinkResourceId(privateLinkResourceId);
        return this;
    }

    @Override
    public OriginProperties withPrivateLinkLocation(String privateLinkLocation) {
        super.withPrivateLinkLocation(privateLinkLocation);
        return this;
    }

    @Override
    public OriginProperties withPrivateLinkApprovalMessage(String privateLinkApprovalMessage) {
        super.withPrivateLinkApprovalMessage(privateLinkApprovalMessage);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hostName", this.hostname());
        jsonWriter.writeNumberField("httpPort", (Number)this.httpPort());
        jsonWriter.writeNumberField("httpsPort", (Number)this.httpsPort());
        jsonWriter.writeStringField("originHostHeader", this.originHostHeader());
        jsonWriter.writeNumberField("priority", (Number)this.priority());
        jsonWriter.writeNumberField("weight", (Number)this.weight());
        jsonWriter.writeBooleanField("enabled", this.enabled());
        jsonWriter.writeStringField("privateLinkAlias", this.privateLinkAlias());
        jsonWriter.writeStringField("privateLinkResourceId", this.privateLinkResourceId());
        jsonWriter.writeStringField("privateLinkLocation", this.privateLinkLocation());
        jsonWriter.writeStringField("privateLinkApprovalMessage", this.privateLinkApprovalMessage());
        return jsonWriter.writeEndObject();
    }

    public static OriginProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OriginProperties)jsonReader.readObject(reader -> {
            OriginProperties deserializedOriginProperties = new OriginProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hostName".equals(fieldName)) {
                    deserializedOriginProperties.withHostname(reader.getString());
                    continue;
                }
                if ("httpPort".equals(fieldName)) {
                    deserializedOriginProperties.withHttpPort((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("httpsPort".equals(fieldName)) {
                    deserializedOriginProperties.withHttpsPort((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("originHostHeader".equals(fieldName)) {
                    deserializedOriginProperties.withOriginHostHeader(reader.getString());
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedOriginProperties.withPriority((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedOriginProperties.withWeight((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedOriginProperties.withEnabled((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("privateLinkAlias".equals(fieldName)) {
                    deserializedOriginProperties.withPrivateLinkAlias(reader.getString());
                    continue;
                }
                if ("privateLinkResourceId".equals(fieldName)) {
                    deserializedOriginProperties.withPrivateLinkResourceId(reader.getString());
                    continue;
                }
                if ("privateLinkLocation".equals(fieldName)) {
                    deserializedOriginProperties.withPrivateLinkLocation(reader.getString());
                    continue;
                }
                if ("privateLinkApprovalMessage".equals(fieldName)) {
                    deserializedOriginProperties.withPrivateLinkApprovalMessage(reader.getString());
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedOriginProperties.resourceState = OriginResourceState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedOriginProperties.provisioningState = OriginProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateEndpointStatus".equals(fieldName)) {
                    deserializedOriginProperties.privateEndpointStatus = PrivateEndpointStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOriginProperties;
        });
    }
}

