/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.CustomDomainProperties;
import com.azure.resourcemanager.cdn.models.CustomDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.CustomDomainResourceState;
import com.azure.resourcemanager.cdn.models.CustomHttpsProvisioningState;
import com.azure.resourcemanager.cdn.models.CustomHttpsProvisioningSubstate;
import java.io.IOException;

public final class CustomDomainInner
extends ProxyResource {
    private CustomDomainProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private CustomDomainProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    public CustomDomainInner withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomDomainProperties();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    public CustomDomainResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public CustomHttpsProvisioningState customHttpsProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().customHttpsProvisioningState();
    }

    public CustomHttpsProvisioningSubstate customHttpsProvisioningSubstate() {
        return this.innerProperties() == null ? null : this.innerProperties().customHttpsProvisioningSubstate();
    }

    public CustomDomainHttpsParameters customHttpsParameters() {
        return this.innerProperties() == null ? null : this.innerProperties().customHttpsParameters();
    }

    public CustomDomainInner withCustomHttpsParameters(CustomDomainHttpsParameters customHttpsParameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomDomainProperties();
        }
        this.innerProperties().withCustomHttpsParameters(customHttpsParameters);
        return this;
    }

    public String validationData() {
        return this.innerProperties() == null ? null : this.innerProperties().validationData();
    }

    public CustomDomainInner withValidationData(String validationData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CustomDomainProperties();
        }
        this.innerProperties().withValidationData(validationData);
        return this;
    }

    public CustomHttpsProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CustomDomainInner fromJson(JsonReader jsonReader) throws IOException {
        return (CustomDomainInner)((Object)jsonReader.readObject(reader -> {
            CustomDomainInner deserializedCustomDomainInner = new CustomDomainInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCustomDomainInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCustomDomainInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCustomDomainInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCustomDomainInner.innerProperties = CustomDomainProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCustomDomainInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomDomainInner;
        }));
    }
}

