/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.AfdDomainUpdatePropertiesParameters;
import com.azure.resourcemanager.cdn.models.AfdDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.DomainValidationProperties;
import com.azure.resourcemanager.cdn.models.DomainValidationState;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.io.IOException;
import java.util.Map;

public final class AfdDomainProperties
extends AfdDomainUpdatePropertiesParameters {
    private DomainValidationState domainValidationState;
    private String hostname;
    private Map<String, String> extendedProperties;
    private DomainValidationProperties validationProperties;
    private AfdProvisioningState provisioningState;
    private DeploymentStatus deploymentStatus;
    private String profileName;
    private static final ClientLogger LOGGER = new ClientLogger(AfdDomainProperties.class);

    public DomainValidationState domainValidationState() {
        return this.domainValidationState;
    }

    public String hostname() {
        return this.hostname;
    }

    public AfdDomainProperties withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public Map<String, String> extendedProperties() {
        return this.extendedProperties;
    }

    public AfdDomainProperties withExtendedProperties(Map<String, String> extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    public DomainValidationProperties validationProperties() {
        return this.validationProperties;
    }

    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    @Override
    public String profileName() {
        return this.profileName;
    }

    @Override
    public AfdDomainProperties withTlsSettings(AfdDomainHttpsParameters tlsSettings) {
        super.withTlsSettings(tlsSettings);
        return this;
    }

    @Override
    public AfdDomainProperties withAzureDnsZone(ResourceReference azureDnsZone) {
        super.withAzureDnsZone(azureDnsZone);
        return this;
    }

    @Override
    public AfdDomainProperties withPreValidatedCustomDomainResourceId(ResourceReference preValidatedCustomDomainResourceId) {
        super.withPreValidatedCustomDomainResourceId(preValidatedCustomDomainResourceId);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.hostname() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property hostname in model AfdDomainProperties"));
        }
        if (this.validationProperties() != null) {
            this.validationProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("tlsSettings", (JsonSerializable)this.tlsSettings());
        jsonWriter.writeJsonField("azureDnsZone", (JsonSerializable)this.azureDnsZone());
        jsonWriter.writeJsonField("preValidatedCustomDomainResourceId", (JsonSerializable)this.preValidatedCustomDomainResourceId());
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeMapField("extendedProperties", this.extendedProperties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AfdDomainProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AfdDomainProperties)jsonReader.readObject(reader -> {
            AfdDomainProperties deserializedAfdDomainProperties = new AfdDomainProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("profileName".equals(fieldName)) {
                    deserializedAfdDomainProperties.profileName = reader.getString();
                    continue;
                }
                if ("tlsSettings".equals(fieldName)) {
                    deserializedAfdDomainProperties.withTlsSettings(AfdDomainHttpsParameters.fromJson(reader));
                    continue;
                }
                if ("azureDnsZone".equals(fieldName)) {
                    deserializedAfdDomainProperties.withAzureDnsZone(ResourceReference.fromJson(reader));
                    continue;
                }
                if ("preValidatedCustomDomainResourceId".equals(fieldName)) {
                    deserializedAfdDomainProperties.withPreValidatedCustomDomainResourceId(ResourceReference.fromJson(reader));
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedAfdDomainProperties.hostname = reader.getString();
                    continue;
                }
                if ("domainValidationState".equals(fieldName)) {
                    deserializedAfdDomainProperties.domainValidationState = DomainValidationState.fromString(reader.getString());
                    continue;
                }
                if ("extendedProperties".equals(fieldName)) {
                    Map extendedProperties;
                    deserializedAfdDomainProperties.extendedProperties = extendedProperties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("validationProperties".equals(fieldName)) {
                    deserializedAfdDomainProperties.validationProperties = DomainValidationProperties.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAfdDomainProperties.provisioningState = AfdProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentStatus".equals(fieldName)) {
                    deserializedAfdDomainProperties.deploymentStatus = DeploymentStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAfdDomainProperties;
        });
    }
}

