/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.RequestHeaderOperator;
import com.azure.resourcemanager.cdn.models.Transform;
import java.io.IOException;
import java.util.List;

public final class RequestHeaderMatchConditionParameters
implements JsonSerializable<RequestHeaderMatchConditionParameters> {
    private String typeName = "DeliveryRuleRequestHeaderConditionParameters";
    private String selector;
    private RequestHeaderOperator operator;
    private Boolean negateCondition;
    private List<String> matchValues;
    private List<Transform> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(RequestHeaderMatchConditionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public RequestHeaderMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String selector() {
        return this.selector;
    }

    public RequestHeaderMatchConditionParameters withSelector(String selector) {
        this.selector = selector;
        return this;
    }

    public RequestHeaderOperator operator() {
        return this.operator;
    }

    public RequestHeaderMatchConditionParameters withOperator(RequestHeaderOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public RequestHeaderMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<String> matchValues() {
        return this.matchValues;
    }

    public RequestHeaderMatchConditionParameters withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    public RequestHeaderMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model RequestHeaderMatchConditionParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeStringField("selector", this.selector);
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static RequestHeaderMatchConditionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RequestHeaderMatchConditionParameters)jsonReader.readObject(reader -> {
            RequestHeaderMatchConditionParameters deserializedRequestHeaderMatchConditionParameters = new RequestHeaderMatchConditionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operator".equals(fieldName)) {
                    deserializedRequestHeaderMatchConditionParameters.operator = RequestHeaderOperator.fromString(reader.getString());
                    continue;
                }
                if ("selector".equals(fieldName)) {
                    deserializedRequestHeaderMatchConditionParameters.selector = reader.getString();
                    continue;
                }
                if ("negateCondition".equals(fieldName)) {
                    deserializedRequestHeaderMatchConditionParameters.negateCondition = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List matchValues;
                    deserializedRequestHeaderMatchConditionParameters.matchValues = matchValues = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List transforms;
                    deserializedRequestHeaderMatchConditionParameters.transforms = transforms = reader.readArray(reader1 -> Transform.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequestHeaderMatchConditionParameters;
        });
    }
}

