/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SecurityPolicyPropertiesParameters;
import com.azure.resourcemanager.cdn.models.SecurityPolicyType;
import com.azure.resourcemanager.cdn.models.SecurityPolicyWebApplicationFirewallAssociation;
import java.io.IOException;
import java.util.List;

public final class SecurityPolicyWebApplicationFirewallParameters
extends SecurityPolicyPropertiesParameters {
    private SecurityPolicyType type = SecurityPolicyType.WEB_APPLICATION_FIREWALL;
    private ResourceReference wafPolicy;
    private List<SecurityPolicyWebApplicationFirewallAssociation> associations;

    @Override
    public SecurityPolicyType type() {
        return this.type;
    }

    public ResourceReference wafPolicy() {
        return this.wafPolicy;
    }

    public SecurityPolicyWebApplicationFirewallParameters withWafPolicy(ResourceReference wafPolicy) {
        this.wafPolicy = wafPolicy;
        return this;
    }

    public List<SecurityPolicyWebApplicationFirewallAssociation> associations() {
        return this.associations;
    }

    public SecurityPolicyWebApplicationFirewallParameters withAssociations(List<SecurityPolicyWebApplicationFirewallAssociation> associations) {
        this.associations = associations;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.wafPolicy() != null) {
            this.wafPolicy().validate();
        }
        if (this.associations() != null) {
            this.associations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("wafPolicy", (JsonSerializable)this.wafPolicy);
        jsonWriter.writeArrayField("associations", this.associations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SecurityPolicyWebApplicationFirewallParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityPolicyWebApplicationFirewallParameters)jsonReader.readObject(reader -> {
            SecurityPolicyWebApplicationFirewallParameters deserializedSecurityPolicyWebApplicationFirewallParameters = new SecurityPolicyWebApplicationFirewallParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSecurityPolicyWebApplicationFirewallParameters.type = SecurityPolicyType.fromString(reader.getString());
                    continue;
                }
                if ("wafPolicy".equals(fieldName)) {
                    deserializedSecurityPolicyWebApplicationFirewallParameters.wafPolicy = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("associations".equals(fieldName)) {
                    List associations;
                    deserializedSecurityPolicyWebApplicationFirewallParameters.associations = associations = reader.readArray(reader1 -> SecurityPolicyWebApplicationFirewallAssociation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityPolicyWebApplicationFirewallParameters;
        });
    }
}

