/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CdnCertificateSourceParameters;
import com.azure.resourcemanager.cdn.models.CertificateSource;
import com.azure.resourcemanager.cdn.models.CustomDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.MinimumTlsVersion;
import com.azure.resourcemanager.cdn.models.ProtocolType;
import java.io.IOException;

public final class CdnManagedHttpsParameters
extends CustomDomainHttpsParameters {
    private CertificateSource certificateSource = CertificateSource.CDN;
    private CdnCertificateSourceParameters certificateSourceParameters;
    private static final ClientLogger LOGGER = new ClientLogger(CdnManagedHttpsParameters.class);

    @Override
    public CertificateSource certificateSource() {
        return this.certificateSource;
    }

    public CdnCertificateSourceParameters certificateSourceParameters() {
        return this.certificateSourceParameters;
    }

    public CdnManagedHttpsParameters withCertificateSourceParameters(CdnCertificateSourceParameters certificateSourceParameters) {
        this.certificateSourceParameters = certificateSourceParameters;
        return this;
    }

    @Override
    public CdnManagedHttpsParameters withProtocolType(ProtocolType protocolType) {
        super.withProtocolType(protocolType);
        return this;
    }

    @Override
    public CdnManagedHttpsParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.certificateSourceParameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property certificateSourceParameters in model CdnManagedHttpsParameters"));
        }
        this.certificateSourceParameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocolType", this.protocolType() == null ? null : this.protocolType().toString());
        jsonWriter.writeStringField("minimumTlsVersion", this.minimumTlsVersion() == null ? null : this.minimumTlsVersion().toString());
        jsonWriter.writeJsonField("certificateSourceParameters", (JsonSerializable)this.certificateSourceParameters);
        jsonWriter.writeStringField("certificateSource", this.certificateSource == null ? null : this.certificateSource.toString());
        return jsonWriter.writeEndObject();
    }

    public static CdnManagedHttpsParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CdnManagedHttpsParameters)jsonReader.readObject(reader -> {
            CdnManagedHttpsParameters deserializedCdnManagedHttpsParameters = new CdnManagedHttpsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocolType".equals(fieldName)) {
                    deserializedCdnManagedHttpsParameters.withProtocolType(ProtocolType.fromString(reader.getString()));
                    continue;
                }
                if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedCdnManagedHttpsParameters.withMinimumTlsVersion(MinimumTlsVersion.fromString(reader.getString()));
                    continue;
                }
                if ("certificateSourceParameters".equals(fieldName)) {
                    deserializedCdnManagedHttpsParameters.certificateSourceParameters = CdnCertificateSourceParameters.fromJson(reader);
                    continue;
                }
                if ("certificateSource".equals(fieldName)) {
                    deserializedCdnManagedHttpsParameters.certificateSource = CertificateSource.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCdnManagedHttpsParameters;
        });
    }
}

