/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.AfdEndpointProtocols;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.AfdQueryStringCachingBehavior;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.ForwardingProtocol;
import com.azure.resourcemanager.cdn.models.HttpsRedirect;
import com.azure.resourcemanager.cdn.models.LinkToDefaultDomain;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SystemData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class RouteInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RouteInner.class);
    @JsonProperty(value="properties.customDomains")
    private List<ResourceReference> customDomains;
    @JsonProperty(value="properties.originGroup")
    private ResourceReference originGroup;
    @JsonProperty(value="properties.originPath")
    private String originPath;
    @JsonProperty(value="properties.ruleSets")
    private List<ResourceReference> ruleSets;
    @JsonProperty(value="properties.supportedProtocols")
    private List<AfdEndpointProtocols> supportedProtocols;
    @JsonProperty(value="properties.patternsToMatch")
    private List<String> patternsToMatch;
    @JsonProperty(value="properties.compressionSettings")
    private Object compressionSettings;
    @JsonProperty(value="properties.queryStringCachingBehavior")
    private AfdQueryStringCachingBehavior queryStringCachingBehavior;
    @JsonProperty(value="properties.forwardingProtocol")
    private ForwardingProtocol forwardingProtocol;
    @JsonProperty(value="properties.linkToDefaultDomain")
    private LinkToDefaultDomain linkToDefaultDomain;
    @JsonProperty(value="properties.httpsRedirect")
    private HttpsRedirect httpsRedirect;
    @JsonProperty(value="properties.enabledState")
    private EnabledState enabledState;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;
    @JsonProperty(value="properties.deploymentStatus", access=JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public List<ResourceReference> customDomains() {
        return this.customDomains;
    }

    public RouteInner withCustomDomains(List<ResourceReference> customDomains) {
        this.customDomains = customDomains;
        return this;
    }

    public ResourceReference originGroup() {
        return this.originGroup;
    }

    public RouteInner withOriginGroup(ResourceReference originGroup) {
        this.originGroup = originGroup;
        return this;
    }

    public String originPath() {
        return this.originPath;
    }

    public RouteInner withOriginPath(String originPath) {
        this.originPath = originPath;
        return this;
    }

    public List<ResourceReference> ruleSets() {
        return this.ruleSets;
    }

    public RouteInner withRuleSets(List<ResourceReference> ruleSets) {
        this.ruleSets = ruleSets;
        return this;
    }

    public List<AfdEndpointProtocols> supportedProtocols() {
        return this.supportedProtocols;
    }

    public RouteInner withSupportedProtocols(List<AfdEndpointProtocols> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
        return this;
    }

    public List<String> patternsToMatch() {
        return this.patternsToMatch;
    }

    public RouteInner withPatternsToMatch(List<String> patternsToMatch) {
        this.patternsToMatch = patternsToMatch;
        return this;
    }

    public Object compressionSettings() {
        return this.compressionSettings;
    }

    public RouteInner withCompressionSettings(Object compressionSettings) {
        this.compressionSettings = compressionSettings;
        return this;
    }

    public AfdQueryStringCachingBehavior queryStringCachingBehavior() {
        return this.queryStringCachingBehavior;
    }

    public RouteInner withQueryStringCachingBehavior(AfdQueryStringCachingBehavior queryStringCachingBehavior) {
        this.queryStringCachingBehavior = queryStringCachingBehavior;
        return this;
    }

    public ForwardingProtocol forwardingProtocol() {
        return this.forwardingProtocol;
    }

    public RouteInner withForwardingProtocol(ForwardingProtocol forwardingProtocol) {
        this.forwardingProtocol = forwardingProtocol;
        return this;
    }

    public LinkToDefaultDomain linkToDefaultDomain() {
        return this.linkToDefaultDomain;
    }

    public RouteInner withLinkToDefaultDomain(LinkToDefaultDomain linkToDefaultDomain) {
        this.linkToDefaultDomain = linkToDefaultDomain;
        return this;
    }

    public HttpsRedirect httpsRedirect() {
        return this.httpsRedirect;
    }

    public RouteInner withHttpsRedirect(HttpsRedirect httpsRedirect) {
        this.httpsRedirect = httpsRedirect;
        return this;
    }

    public EnabledState enabledState() {
        return this.enabledState;
    }

    public RouteInner withEnabledState(EnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public void validate() {
        if (this.customDomains() != null) {
            this.customDomains().forEach(e -> e.validate());
        }
        if (this.originGroup() != null) {
            this.originGroup().validate();
        }
        if (this.ruleSets() != null) {
            this.ruleSets().forEach(e -> e.validate());
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }
}

