/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.Algorithm;
import com.azure.resourcemanager.cdn.models.UrlSigningActionParametersOdataType;
import com.azure.resourcemanager.cdn.models.UrlSigningParamIdentifier;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class UrlSigningActionParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(UrlSigningActionParameters.class);
    @JsonProperty(value="@odata.type")
    private UrlSigningActionParametersOdataType odataType;
    @JsonProperty(value="keyId", required=true)
    private String keyId;
    @JsonProperty(value="algorithm")
    private Algorithm algorithm;
    @JsonProperty(value="parameterNameOverride")
    private List<UrlSigningParamIdentifier> parameterNameOverride;
    @JsonProperty(value="ipSubnets")
    private List<String> ipSubnets;

    public UrlSigningActionParametersOdataType odataType() {
        return this.odataType;
    }

    public UrlSigningActionParameters withOdataType(UrlSigningActionParametersOdataType odataType) {
        this.odataType = odataType;
        return this;
    }

    public String keyId() {
        return this.keyId;
    }

    public UrlSigningActionParameters withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public Algorithm algorithm() {
        return this.algorithm;
    }

    public UrlSigningActionParameters withAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public List<UrlSigningParamIdentifier> parameterNameOverride() {
        return this.parameterNameOverride;
    }

    public UrlSigningActionParameters withParameterNameOverride(List<UrlSigningParamIdentifier> parameterNameOverride) {
        this.parameterNameOverride = parameterNameOverride;
        return this;
    }

    public List<String> ipSubnets() {
        return this.ipSubnets;
    }

    public UrlSigningActionParameters withIpSubnets(List<String> ipSubnets) {
        this.ipSubnets = ipSubnets;
        return this;
    }

    public void validate() {
        if (this.keyId() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property keyId in model UrlSigningActionParameters"));
        }
        if (this.parameterNameOverride() != null) {
            this.parameterNameOverride().forEach(e -> e.validate());
        }
    }
}

