/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.QueryStringOperator;
import com.azure.resourcemanager.cdn.models.Transform;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class QueryStringMatchConditionParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(QueryStringMatchConditionParameters.class);
    @JsonProperty(value="@odata.type", required=true)
    private String odataType = "#Microsoft.Azure.Cdn.Models.DeliveryRuleQueryStringConditionParameters";
    @JsonProperty(value="operator", required=true)
    private QueryStringOperator operator;
    @JsonProperty(value="negateCondition")
    private Boolean negateCondition;
    @JsonProperty(value="matchValues")
    private List<String> matchValues;
    @JsonProperty(value="transforms")
    private List<Transform> transforms;

    public String odataType() {
        return this.odataType;
    }

    public QueryStringMatchConditionParameters withOdataType(String odataType) {
        this.odataType = odataType;
        return this;
    }

    public QueryStringOperator operator() {
        return this.operator;
    }

    public QueryStringMatchConditionParameters withOperator(QueryStringOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public QueryStringMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<String> matchValues() {
        return this.matchValues;
    }

    public QueryStringMatchConditionParameters withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    public QueryStringMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.operator() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property operator in model QueryStringMatchConditionParameters"));
        }
    }
}

