/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.CdnManagementClient;
import com.azure.resourcemanager.cdn.fluent.CustomDomainsClient;
import com.azure.resourcemanager.cdn.fluent.EdgeNodesClient;
import com.azure.resourcemanager.cdn.fluent.EndpointsClient;
import com.azure.resourcemanager.cdn.fluent.ManagedRuleSetsClient;
import com.azure.resourcemanager.cdn.fluent.OperationsClient;
import com.azure.resourcemanager.cdn.fluent.OriginGroupsClient;
import com.azure.resourcemanager.cdn.fluent.OriginsClient;
import com.azure.resourcemanager.cdn.fluent.PoliciesClient;
import com.azure.resourcemanager.cdn.fluent.ProfilesClient;
import com.azure.resourcemanager.cdn.fluent.ResourceUsagesClient;
import com.azure.resourcemanager.cdn.fluent.models.CheckNameAvailabilityOutputInner;
import com.azure.resourcemanager.cdn.fluent.models.ValidateProbeOutputInner;
import com.azure.resourcemanager.cdn.implementation.CustomDomainsClientImpl;
import com.azure.resourcemanager.cdn.implementation.EdgeNodesClientImpl;
import com.azure.resourcemanager.cdn.implementation.EndpointsClientImpl;
import com.azure.resourcemanager.cdn.implementation.ManagedRuleSetsClientImpl;
import com.azure.resourcemanager.cdn.implementation.OperationsClientImpl;
import com.azure.resourcemanager.cdn.implementation.OriginGroupsClientImpl;
import com.azure.resourcemanager.cdn.implementation.OriginsClientImpl;
import com.azure.resourcemanager.cdn.implementation.PoliciesClientImpl;
import com.azure.resourcemanager.cdn.implementation.ProfilesClientImpl;
import com.azure.resourcemanager.cdn.implementation.ResourceUsagesClientImpl;
import com.azure.resourcemanager.cdn.models.CheckNameAvailabilityInput;
import com.azure.resourcemanager.cdn.models.ValidateProbeInput;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class CdnManagementClientImpl
extends AzureServiceClient
implements CdnManagementClient {
    private final ClientLogger logger = new ClientLogger(CdnManagementClientImpl.class);
    private final CdnManagementClientService service;
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final ProfilesClient profiles;
    private final EndpointsClient endpoints;
    private final OriginsClient origins;
    private final OriginGroupsClient originGroups;
    private final CustomDomainsClient customDomains;
    private final ResourceUsagesClient resourceUsages;
    private final OperationsClient operations;
    private final EdgeNodesClient edgeNodes;
    private final PoliciesClient policies;
    private final ManagedRuleSetsClient managedRuleSets;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public ProfilesClient getProfiles() {
        return this.profiles;
    }

    @Override
    public EndpointsClient getEndpoints() {
        return this.endpoints;
    }

    @Override
    public OriginsClient getOrigins() {
        return this.origins;
    }

    @Override
    public OriginGroupsClient getOriginGroups() {
        return this.originGroups;
    }

    @Override
    public CustomDomainsClient getCustomDomains() {
        return this.customDomains;
    }

    @Override
    public ResourceUsagesClient getResourceUsages() {
        return this.resourceUsages;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public EdgeNodesClient getEdgeNodes() {
        return this.edgeNodes;
    }

    @Override
    public PoliciesClient getPolicies() {
        return this.policies;
    }

    @Override
    public ManagedRuleSetsClient getManagedRuleSets() {
        return this.managedRuleSets;
    }

    CdnManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2020-04-15";
        this.profiles = new ProfilesClientImpl(this);
        this.endpoints = new EndpointsClientImpl(this);
        this.origins = new OriginsClientImpl(this);
        this.originGroups = new OriginGroupsClientImpl(this);
        this.customDomains = new CustomDomainsClientImpl(this);
        this.resourceUsages = new ResourceUsagesClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.edgeNodes = new EdgeNodesClientImpl(this);
        this.policies = new PoliciesClientImpl(this);
        this.managedRuleSets = new ManagedRuleSetsClientImpl(this);
        this.service = (CdnManagementClientService)RestProxy.create(CdnManagementClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @Override
    public Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithResponseAsync(String name) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String accept = "application/json";
        CheckNameAvailabilityInput checkNameAvailabilityInput = new CheckNameAvailabilityInput();
        checkNameAvailabilityInput.withName(name);
        return FluxUtil.withContext(context -> this.service.checkNameAvailability(this.getEndpoint(), this.getApiVersion(), checkNameAvailabilityInput, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.getContext())));
    }

    private Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithResponseAsync(String name, Context context) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String accept = "application/json";
        CheckNameAvailabilityInput checkNameAvailabilityInput = new CheckNameAvailabilityInput();
        checkNameAvailabilityInput.withName(name);
        context = this.mergeContext(context);
        return this.service.checkNameAvailability(this.getEndpoint(), this.getApiVersion(), checkNameAvailabilityInput, "application/json", context);
    }

    @Override
    public Mono<CheckNameAvailabilityOutputInner> checkNameAvailabilityAsync(String name) {
        return this.checkNameAvailabilityWithResponseAsync(name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CheckNameAvailabilityOutputInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public CheckNameAvailabilityOutputInner checkNameAvailability(String name) {
        return (CheckNameAvailabilityOutputInner)this.checkNameAvailabilityAsync(name).block();
    }

    @Override
    public Response<CheckNameAvailabilityOutputInner> checkNameAvailabilityWithResponse(String name, Context context) {
        return (Response)this.checkNameAvailabilityWithResponseAsync(name, context).block();
    }

    @Override
    public Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithSubscriptionWithResponseAsync(String name) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String accept = "application/json";
        CheckNameAvailabilityInput checkNameAvailabilityInput = new CheckNameAvailabilityInput();
        checkNameAvailabilityInput.withName(name);
        return FluxUtil.withContext(context -> this.service.checkNameAvailabilityWithSubscription(this.getEndpoint(), this.getSubscriptionId(), this.getApiVersion(), checkNameAvailabilityInput, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.getContext())));
    }

    private Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithSubscriptionWithResponseAsync(String name, Context context) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String accept = "application/json";
        CheckNameAvailabilityInput checkNameAvailabilityInput = new CheckNameAvailabilityInput();
        checkNameAvailabilityInput.withName(name);
        context = this.mergeContext(context);
        return this.service.checkNameAvailabilityWithSubscription(this.getEndpoint(), this.getSubscriptionId(), this.getApiVersion(), checkNameAvailabilityInput, "application/json", context);
    }

    @Override
    public Mono<CheckNameAvailabilityOutputInner> checkNameAvailabilityWithSubscriptionAsync(String name) {
        return this.checkNameAvailabilityWithSubscriptionWithResponseAsync(name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CheckNameAvailabilityOutputInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public CheckNameAvailabilityOutputInner checkNameAvailabilityWithSubscription(String name) {
        return (CheckNameAvailabilityOutputInner)this.checkNameAvailabilityWithSubscriptionAsync(name).block();
    }

    @Override
    public Response<CheckNameAvailabilityOutputInner> checkNameAvailabilityWithSubscriptionWithResponse(String name, Context context) {
        return (Response)this.checkNameAvailabilityWithSubscriptionWithResponseAsync(name, context).block();
    }

    @Override
    public Mono<Response<ValidateProbeOutputInner>> validateProbeWithResponseAsync(String probeUrl) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (probeUrl == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter probeUrl is required and cannot be null."));
        }
        String accept = "application/json";
        ValidateProbeInput validateProbeInput = new ValidateProbeInput();
        validateProbeInput.withProbeUrl(probeUrl);
        return FluxUtil.withContext(context -> this.service.validateProbe(this.getEndpoint(), this.getSubscriptionId(), this.getApiVersion(), validateProbeInput, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.getContext())));
    }

    private Mono<Response<ValidateProbeOutputInner>> validateProbeWithResponseAsync(String probeUrl, Context context) {
        if (this.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (probeUrl == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter probeUrl is required and cannot be null."));
        }
        String accept = "application/json";
        ValidateProbeInput validateProbeInput = new ValidateProbeInput();
        validateProbeInput.withProbeUrl(probeUrl);
        context = this.mergeContext(context);
        return this.service.validateProbe(this.getEndpoint(), this.getSubscriptionId(), this.getApiVersion(), validateProbeInput, "application/json", context);
    }

    @Override
    public Mono<ValidateProbeOutputInner> validateProbeAsync(String probeUrl) {
        return this.validateProbeWithResponseAsync(probeUrl).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ValidateProbeOutputInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ValidateProbeOutputInner validateProbe(String probeUrl) {
        return (ValidateProbeOutputInner)this.validateProbeAsync(probeUrl).block();
    }

    @Override
    public Response<ValidateProbeOutputInner> validateProbeWithResponse(String probeUrl, Context context) {
        return (Response)this.validateProbeWithResponseAsync(probeUrl, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClient")
    private static interface CdnManagementClientService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Cdn/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailability(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") CheckNameAvailabilityInput var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithSubscription(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CheckNameAvailabilityInput var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/validateProbe")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ValidateProbeOutputInner>> validateProbe(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ValidateProbeInput var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

