/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.DeepCreatedOrigin;
import com.azure.resourcemanager.cdn.models.DeepCreatedOriginGroup;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink;
import com.azure.resourcemanager.cdn.models.EndpointResourceState;
import com.azure.resourcemanager.cdn.models.GeoFilter;
import com.azure.resourcemanager.cdn.models.OptimizationType;
import com.azure.resourcemanager.cdn.models.QueryStringCachingBehavior;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.UrlSigningKey;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class EndpointInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EndpointInner.class);
    @JsonProperty(value="properties.originPath")
    private String originPath;
    @JsonProperty(value="properties.contentTypesToCompress")
    private List<String> contentTypesToCompress;
    @JsonProperty(value="properties.originHostHeader")
    private String originHostHeader;
    @JsonProperty(value="properties.isCompressionEnabled")
    private Boolean isCompressionEnabled;
    @JsonProperty(value="properties.isHttpAllowed")
    private Boolean isHttpAllowed;
    @JsonProperty(value="properties.isHttpsAllowed")
    private Boolean isHttpsAllowed;
    @JsonProperty(value="properties.queryStringCachingBehavior")
    private QueryStringCachingBehavior queryStringCachingBehavior;
    @JsonProperty(value="properties.optimizationType")
    private OptimizationType optimizationType;
    @JsonProperty(value="properties.probePath")
    private String probePath;
    @JsonProperty(value="properties.geoFilters")
    private List<GeoFilter> geoFilters;
    @JsonProperty(value="properties.defaultOriginGroup")
    private ResourceReference defaultOriginGroup;
    @JsonProperty(value="properties.urlSigningKeys")
    private List<UrlSigningKey> urlSigningKeys;
    @JsonProperty(value="properties.deliveryPolicy")
    private EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy;
    @JsonProperty(value="properties.webApplicationFirewallPolicyLink")
    private EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink;
    @JsonProperty(value="properties.hostName", access=JsonProperty.Access.WRITE_ONLY)
    private String hostname;
    @JsonProperty(value="properties.origins")
    private List<DeepCreatedOrigin> origins;
    @JsonProperty(value="properties.originGroups")
    private List<DeepCreatedOriginGroup> originGroups;
    @JsonProperty(value="properties.resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private EndpointResourceState resourceState;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    public String originPath() {
        return this.originPath;
    }

    public EndpointInner withOriginPath(String originPath) {
        this.originPath = originPath;
        return this;
    }

    public List<String> contentTypesToCompress() {
        return this.contentTypesToCompress;
    }

    public EndpointInner withContentTypesToCompress(List<String> contentTypesToCompress) {
        this.contentTypesToCompress = contentTypesToCompress;
        return this;
    }

    public String originHostHeader() {
        return this.originHostHeader;
    }

    public EndpointInner withOriginHostHeader(String originHostHeader) {
        this.originHostHeader = originHostHeader;
        return this;
    }

    public Boolean isCompressionEnabled() {
        return this.isCompressionEnabled;
    }

    public EndpointInner withIsCompressionEnabled(Boolean isCompressionEnabled) {
        this.isCompressionEnabled = isCompressionEnabled;
        return this;
    }

    public Boolean isHttpAllowed() {
        return this.isHttpAllowed;
    }

    public EndpointInner withIsHttpAllowed(Boolean isHttpAllowed) {
        this.isHttpAllowed = isHttpAllowed;
        return this;
    }

    public Boolean isHttpsAllowed() {
        return this.isHttpsAllowed;
    }

    public EndpointInner withIsHttpsAllowed(Boolean isHttpsAllowed) {
        this.isHttpsAllowed = isHttpsAllowed;
        return this;
    }

    public QueryStringCachingBehavior queryStringCachingBehavior() {
        return this.queryStringCachingBehavior;
    }

    public EndpointInner withQueryStringCachingBehavior(QueryStringCachingBehavior queryStringCachingBehavior) {
        this.queryStringCachingBehavior = queryStringCachingBehavior;
        return this;
    }

    public OptimizationType optimizationType() {
        return this.optimizationType;
    }

    public EndpointInner withOptimizationType(OptimizationType optimizationType) {
        this.optimizationType = optimizationType;
        return this;
    }

    public String probePath() {
        return this.probePath;
    }

    public EndpointInner withProbePath(String probePath) {
        this.probePath = probePath;
        return this;
    }

    public List<GeoFilter> geoFilters() {
        return this.geoFilters;
    }

    public EndpointInner withGeoFilters(List<GeoFilter> geoFilters) {
        this.geoFilters = geoFilters;
        return this;
    }

    public ResourceReference defaultOriginGroup() {
        return this.defaultOriginGroup;
    }

    public EndpointInner withDefaultOriginGroup(ResourceReference defaultOriginGroup) {
        this.defaultOriginGroup = defaultOriginGroup;
        return this;
    }

    public List<UrlSigningKey> urlSigningKeys() {
        return this.urlSigningKeys;
    }

    public EndpointInner withUrlSigningKeys(List<UrlSigningKey> urlSigningKeys) {
        this.urlSigningKeys = urlSigningKeys;
        return this;
    }

    public EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy() {
        return this.deliveryPolicy;
    }

    public EndpointInner withDeliveryPolicy(EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy) {
        this.deliveryPolicy = deliveryPolicy;
        return this;
    }

    public EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink() {
        return this.webApplicationFirewallPolicyLink;
    }

    public EndpointInner withWebApplicationFirewallPolicyLink(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        this.webApplicationFirewallPolicyLink = webApplicationFirewallPolicyLink;
        return this;
    }

    public String hostname() {
        return this.hostname;
    }

    public List<DeepCreatedOrigin> origins() {
        return this.origins;
    }

    public EndpointInner withOrigins(List<DeepCreatedOrigin> origins) {
        this.origins = origins;
        return this;
    }

    public List<DeepCreatedOriginGroup> originGroups() {
        return this.originGroups;
    }

    public EndpointInner withOriginGroups(List<DeepCreatedOriginGroup> originGroups) {
        this.originGroups = originGroups;
        return this;
    }

    public EndpointResourceState resourceState() {
        return this.resourceState;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public EndpointInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public EndpointInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.geoFilters() != null) {
            this.geoFilters().forEach(e -> e.validate());
        }
        if (this.defaultOriginGroup() != null) {
            this.defaultOriginGroup().validate();
        }
        if (this.urlSigningKeys() != null) {
            this.urlSigningKeys().forEach(e -> e.validate());
        }
        if (this.deliveryPolicy() != null) {
            this.deliveryPolicy().validate();
        }
        if (this.webApplicationFirewallPolicyLink() != null) {
            this.webApplicationFirewallPolicyLink().validate();
        }
        if (this.origins() != null) {
            this.origins().forEach(e -> e.validate());
        }
        if (this.originGroups() != null) {
            this.originGroups().forEach(e -> e.validate());
        }
    }
}

