/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.carbonoptimization.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.carbonoptimization.models.CategoryTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.DateRange;
import com.azure.resourcemanager.carbonoptimization.models.EmissionScopeEnum;
import com.azure.resourcemanager.carbonoptimization.models.OrderByColumnEnum;
import com.azure.resourcemanager.carbonoptimization.models.QueryFilter;
import com.azure.resourcemanager.carbonoptimization.models.ReportTypeEnum;
import com.azure.resourcemanager.carbonoptimization.models.SortDirectionEnum;
import java.io.IOException;
import java.util.List;

public final class ItemDetailsQueryFilter
extends QueryFilter {
    private ReportTypeEnum reportType = ReportTypeEnum.ITEM_DETAILS_REPORT;
    private CategoryTypeEnum categoryType;
    private OrderByColumnEnum orderBy;
    private SortDirectionEnum sortDirection;
    private int pageSize;
    private String skipToken;
    private static final ClientLogger LOGGER = new ClientLogger(ItemDetailsQueryFilter.class);

    @Override
    public ReportTypeEnum reportType() {
        return this.reportType;
    }

    public CategoryTypeEnum categoryType() {
        return this.categoryType;
    }

    public ItemDetailsQueryFilter withCategoryType(CategoryTypeEnum categoryType) {
        this.categoryType = categoryType;
        return this;
    }

    public OrderByColumnEnum orderBy() {
        return this.orderBy;
    }

    public ItemDetailsQueryFilter withOrderBy(OrderByColumnEnum orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public SortDirectionEnum sortDirection() {
        return this.sortDirection;
    }

    public ItemDetailsQueryFilter withSortDirection(SortDirectionEnum sortDirection) {
        this.sortDirection = sortDirection;
        return this;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public ItemDetailsQueryFilter withPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public String skipToken() {
        return this.skipToken;
    }

    public ItemDetailsQueryFilter withSkipToken(String skipToken) {
        this.skipToken = skipToken;
        return this;
    }

    @Override
    public ItemDetailsQueryFilter withDateRange(DateRange dateRange) {
        super.withDateRange(dateRange);
        return this;
    }

    @Override
    public ItemDetailsQueryFilter withSubscriptionList(List<String> subscriptionList) {
        super.withSubscriptionList(subscriptionList);
        return this;
    }

    @Override
    public ItemDetailsQueryFilter withResourceGroupUrlList(List<String> resourceGroupUrlList) {
        super.withResourceGroupUrlList(resourceGroupUrlList);
        return this;
    }

    @Override
    public ItemDetailsQueryFilter withResourceTypeList(List<String> resourceTypeList) {
        super.withResourceTypeList(resourceTypeList);
        return this;
    }

    @Override
    public ItemDetailsQueryFilter withLocationList(List<String> locationList) {
        super.withLocationList(locationList);
        return this;
    }

    @Override
    public ItemDetailsQueryFilter withCarbonScopeList(List<EmissionScopeEnum> carbonScopeList) {
        super.withCarbonScopeList(carbonScopeList);
        return this;
    }

    @Override
    public void validate() {
        if (this.categoryType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property categoryType in model ItemDetailsQueryFilter"));
        }
        if (this.orderBy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property orderBy in model ItemDetailsQueryFilter"));
        }
        if (this.sortDirection() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sortDirection in model ItemDetailsQueryFilter"));
        }
        if (this.dateRange() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dateRange in model ItemDetailsQueryFilter"));
        }
        this.dateRange().validate();
        if (this.subscriptionList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionList in model ItemDetailsQueryFilter"));
        }
        if (this.carbonScopeList() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property carbonScopeList in model ItemDetailsQueryFilter"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dateRange", (JsonSerializable)this.dateRange());
        jsonWriter.writeArrayField("subscriptionList", this.subscriptionList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("carbonScopeList", this.carbonScopeList(), (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("resourceGroupUrlList", this.resourceGroupUrlList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("resourceTypeList", this.resourceTypeList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("locationList", this.locationList(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("categoryType", this.categoryType == null ? null : this.categoryType.toString());
        jsonWriter.writeStringField("orderBy", this.orderBy == null ? null : this.orderBy.toString());
        jsonWriter.writeStringField("sortDirection", this.sortDirection == null ? null : this.sortDirection.toString());
        jsonWriter.writeIntField("pageSize", this.pageSize);
        jsonWriter.writeStringField("reportType", this.reportType == null ? null : this.reportType.toString());
        jsonWriter.writeStringField("skipToken", this.skipToken);
        return jsonWriter.writeEndObject();
    }

    public static ItemDetailsQueryFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ItemDetailsQueryFilter)jsonReader.readObject(reader -> {
            ItemDetailsQueryFilter deserializedItemDetailsQueryFilter = new ItemDetailsQueryFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dateRange".equals(fieldName)) {
                    deserializedItemDetailsQueryFilter.withDateRange(DateRange.fromJson(reader));
                    continue;
                }
                if ("subscriptionList".equals(fieldName)) {
                    List subscriptionList = reader.readArray(reader1 -> reader1.getString());
                    deserializedItemDetailsQueryFilter.withSubscriptionList(subscriptionList);
                    continue;
                }
                if ("carbonScopeList".equals(fieldName)) {
                    List carbonScopeList = reader.readArray(reader1 -> EmissionScopeEnum.fromString(reader1.getString()));
                    deserializedItemDetailsQueryFilter.withCarbonScopeList(carbonScopeList);
                    continue;
                }
                if ("resourceGroupUrlList".equals(fieldName)) {
                    List resourceGroupUrlList = reader.readArray(reader1 -> reader1.getString());
                    deserializedItemDetailsQueryFilter.withResourceGroupUrlList(resourceGroupUrlList);
                    continue;
                }
                if ("resourceTypeList".equals(fieldName)) {
                    List resourceTypeList = reader.readArray(reader1 -> reader1.getString());
                    deserializedItemDetailsQueryFilter.withResourceTypeList(resourceTypeList);
                    continue;
                }
                if ("locationList".equals(fieldName)) {
                    List locationList = reader.readArray(reader1 -> reader1.getString());
                    deserializedItemDetailsQueryFilter.withLocationList(locationList);
                    continue;
                }
                if ("categoryType".equals(fieldName)) {
                    deserializedItemDetailsQueryFilter.categoryType = CategoryTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("orderBy".equals(fieldName)) {
                    deserializedItemDetailsQueryFilter.orderBy = OrderByColumnEnum.fromString(reader.getString());
                    continue;
                }
                if ("sortDirection".equals(fieldName)) {
                    deserializedItemDetailsQueryFilter.sortDirection = SortDirectionEnum.fromString(reader.getString());
                    continue;
                }
                if ("pageSize".equals(fieldName)) {
                    deserializedItemDetailsQueryFilter.pageSize = reader.getInt();
                    continue;
                }
                if ("reportType".equals(fieldName)) {
                    deserializedItemDetailsQueryFilter.reportType = ReportTypeEnum.fromString(reader.getString());
                    continue;
                }
                if ("skipToken".equals(fieldName)) {
                    deserializedItemDetailsQueryFilter.skipToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedItemDetailsQueryFilter;
        });
    }
}

